/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.data;

import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Edge
implements IElement {
    private long[] srcdst;
    private IntFloatVector feats;
    private int[] types;
    private float[] attrs;

    public Edge(long src, long dst, IntFloatVector feats, int[] types, float[] attrs) {
        this.srcdst = new long[2];
        this.srcdst[0] = src;
        this.srcdst[1] = dst;
        this.feats = feats;
        this.types = types;
        this.attrs = attrs;
    }

    public Edge(long src, long dst, float weight) {
        this.srcdst = new long[2];
        this.srcdst[0] = src;
        this.srcdst[1] = dst;
        this.attrs = new float[3];
        this.attrs[0] = weight;
    }

    public Edge(float weight) {
        this.attrs = new float[3];
        this.attrs[0] = weight;
    }

    public Edge(long src, long dst, int[] types, float[] attrs) {
        this(src, dst, null, types, attrs);
    }

    public void setSrc(long src) {
        if (this.srcdst == null) {
            this.srcdst = new long[2];
            this.srcdst[0] = src;
        } else {
            this.srcdst[0] = src;
        }
    }

    public long getSrc() {
        if (this.srcdst != null) {
            return this.srcdst[0];
        }
        return -1L;
    }

    public void setDst(long dst) {
        if (this.srcdst == null) {
            this.srcdst = new long[2];
            this.srcdst[1] = dst;
        } else {
            this.srcdst[1] = dst;
        }
    }

    public long getDst() {
        if (this.srcdst != null) {
            return this.srcdst[1];
        }
        return -1L;
    }

    public IntFloatVector getFeats() {
        return this.feats;
    }

    public void setFeats(IntFloatVector feats) {
        this.feats = feats;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public float getWeight() {
        return this.attrs[0];
    }

    public void setWeight(float attrW) {
        this.attrs[0] = attrW;
    }

    public float getJ() {
        return this.attrs[1];
    }

    public void setJ(float sttr_j) {
        this.attrs[1] = sttr_j;
    }

    public float getP() {
        return this.attrs[2];
    }

    public void setP(float sttr_p) {
        this.attrs[2] = sttr_p;
    }

    public Object deepClone() {
        return null;
    }

    public void serialize(ByteBuf output) {
    }

    public void deserialize(ByteBuf input) {
    }

    public int bufferLen() {
        return 0;
    }

    public void serialize(DataOutputStream output) throws IOException {
    }

    public void deserialize(DataInputStream input) throws IOException {
    }

    public int dataLen() {
        return 0;
    }
}

