/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.data;

import com.tencent.angel.graph.data.NodeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Node
implements IElement {
    private IntFloatVector feats;
    private long[] neighbors;
    private int[] types;
    private float[] attrs;

    public Node(IntFloatVector feats, long[] neighbors) {
        this(feats, neighbors, null);
    }

    public Node(IntFloatVector feats, long[] neighbors, int[] types) {
        this.feats = feats;
        this.neighbors = neighbors;
        this.types = types;
    }

    public Node() {
        this(null, null, null);
    }

    public IntFloatVector getFeats() {
        return this.feats;
    }

    public void setFeats(IntFloatVector feats) {
        this.feats = feats;
    }

    public long[] getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(long[] neighbors) {
        this.neighbors = neighbors;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public float getWeight() {
        return this.attrs[0];
    }

    public void setWeight(float attrW) {
        this.attrs[0] = attrW;
    }

    public float getJ() {
        return this.attrs[1];
    }

    public void setJ(float sttr_j) {
        this.attrs[1] = sttr_j;
    }

    public float getP() {
        return this.attrs[2];
    }

    public void setP(float sttr_p) {
        this.attrs[2] = sttr_p;
    }

    public com.tencent.angel.graph.data.Node deepClone() {
        IntFloatVector cloneFeats = this.feats.clone();
        long[] cloneNeighbors = new long[this.neighbors.length];
        System.arraycopy(this.neighbors, 0, cloneNeighbors, 0, this.neighbors.length);
        if (this.types == null) {
            return new com.tencent.angel.graph.data.Node(cloneFeats, cloneNeighbors);
        }
        int[] cloneTypes = new int[this.types.length];
        System.arraycopy(this.types, 0, cloneTypes, 0, this.types.length);
        return new com.tencent.angel.graph.data.Node(cloneFeats, cloneNeighbors, cloneTypes);
    }

    public void serialize(ByteBuf output) {
        int i;
        NodeUtils.serialize(this.feats, output);
        output.writeInt(this.neighbors.length);
        for (i = 0; i < this.neighbors.length; ++i) {
            output.writeLong(this.neighbors[i]);
        }
        if (this.types != null) {
            output.writeInt(this.types.length);
            for (i = 0; i < this.types.length; ++i) {
                output.writeInt(this.types[i]);
            }
        }
    }

    public void deserialize(ByteBuf input) {
        int i;
        this.feats = NodeUtils.deserialize(input);
        int len = input.readInt();
        this.neighbors = new long[len];
        for (i = 0; i < len; ++i) {
            this.neighbors[i] = input.readLong();
        }
        if (this.types != null) {
            len = input.readInt();
            this.types = new int[len];
            for (i = 0; i < len; ++i) {
                this.types[i] = input.readInt();
            }
        }
    }

    public int bufferLen() {
        int len = NodeUtils.dataLen(this.feats);
        len += 4 + 8 * this.neighbors.length;
        if (this.types != null) {
            len += 4 + 4 * this.types.length;
        }
        return len;
    }

    public void serialize(DataOutputStream output) throws IOException {
        int i;
        NodeUtils.serialize(this.feats, output);
        output.writeInt(this.neighbors.length);
        for (i = 0; i < this.neighbors.length; ++i) {
            output.writeLong(this.neighbors[i]);
        }
        if (this.types != null) {
            output.writeInt(this.types.length);
            for (i = 0; i < this.types.length; ++i) {
                output.writeInt(this.types[i]);
            }
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        int i;
        this.feats = NodeUtils.deserialize(input);
        int len = input.readInt();
        this.neighbors = new long[len];
        for (i = 0; i < len; ++i) {
            this.neighbors[i] = input.readLong();
        }
        if (this.types != null) {
            len = input.readInt();
            this.types = new int[len];
            for (i = 0; i < len; ++i) {
                this.types[i] = input.readInt();
            }
        }
    }

    public int dataLen() {
        return this.bufferLen();
    }
}

