/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.data;

import com.tencent.angel.graph.client.node2vec.utils.SerDe;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WalkPath
implements IElement {
    private long[] path;
    private int currPathIdx = 0;

    public int getCurrPathIdx() {
        return this.currPathIdx;
    }

    public void setCurrPathIdx(int currPathIdx) {
        this.currPathIdx = currPathIdx;
    }

    public WalkPath() {
    }

    public WalkPath(long[] path) {
        this.path = path;
        this.currPathIdx = path.length;
    }

    public WalkPath(long[] path, int currPathIdx) {
        this.path = path;
        this.currPathIdx = currPathIdx;
    }

    public WalkPath(int pathLength, long ... eles) {
        this.path = new long[pathLength];
        if (eles != null) {
            long[] lArray = eles;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                long e;
                this.path[this.currPathIdx] = e = lArray[i];
                ++this.currPathIdx;
            }
        }
    }

    public long[] getPath() {
        return this.path;
    }

    public void setPath(long[] path) {
        this.path = path;
    }

    public WalkPath add2Path(long ele) {
        assert (this.currPathIdx < this.path.length);
        this.path[this.currPathIdx] = ele;
        ++this.currPathIdx;
        return this;
    }

    public long[] getTail2() {
        return new long[]{this.path[this.currPathIdx - 2], this.path[this.currPathIdx - 1]};
    }

    public long getHead() {
        return this.path[0];
    }

    public boolean isComplete() {
        return this.currPathIdx >= this.path.length;
    }

    public Object deepClone() {
        long[] clonedPath = (long[])this.path.clone();
        return new WalkPath(clonedPath, this.currPathIdx);
    }

    public void serialize(ByteBuf output) {
        output.writeInt(this.currPathIdx);
        SerDe.serArray(this.path, output);
    }

    public void deserialize(ByteBuf input) {
        this.currPathIdx = input.readInt();
        this.path = SerDe.deserLongArray(input);
    }

    public int bufferLen() {
        int len = 8;
        if (this.path != null) {
            len += this.currPathIdx * 8;
        }
        return len;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeInt(this.currPathIdx);
        if (this.path == null) {
            output.writeInt(0);
        } else {
            output.writeInt(this.path.length);
            for (long e : this.path) {
                output.writeLong(e);
            }
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.currPathIdx = input.readInt();
        int len = input.readInt();
        if (len > 0) {
            this.path = new long[len];
            for (int i = 0; i < len; ++i) {
                this.path[i] = input.readLong();
            }
        }
    }

    public int dataLen() {
        return this.bufferLen();
    }
}

