/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.params;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;

public class PartitionUpdateParamWithIds
extends PartitionUpdateParam {
    protected long[] keyIds;
    protected int startIdx;
    protected int endIdx;

    public PartitionUpdateParamWithIds(int matrixId, boolean updateClock, PartitionKey partKey, long[] keyIds, int startIdx, int endIdx) {
        super(matrixId, partKey, updateClock);
        this.keyIds = keyIds;
        this.startIdx = startIdx;
        this.endIdx = endIdx;
    }

    public PartitionUpdateParamWithIds(int matrixId, PartitionKey partKey, long[] keyIds, int startIdx, int endIdx) {
        super(matrixId, partKey);
        this.keyIds = keyIds;
        this.startIdx = startIdx;
        this.endIdx = endIdx;
    }

    public PartitionUpdateParamWithIds() {
    }

    public long[] getKeyIds() {
        return this.keyIds;
    }

    protected void clear() {
        this.keyIds = null;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int length = this.endIdx - this.startIdx;
        buf.writeInt(length);
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            buf.writeLong(this.keyIds[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        int length = buf.readInt();
        this.keyIds = new long[length];
        this.startIdx = 0;
        this.endIdx = length;
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            this.keyIds[i] = buf.readLong();
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        int length = this.endIdx - this.startIdx;
        return len + 4 + 8 * length;
    }
}

