/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.updatefuncs.initwalkpath;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;

public class InitWalkPathPartitionParam
extends PartitionUpdateParam {
    private int neighborMatrixId;
    private int walkLength;
    private int numParts;
    private int threshold;
    private double keepProba;
    private boolean isTrunc;

    public InitWalkPathPartitionParam(int matrixId, PartitionKey partKey, boolean updateClock, int neighborMatrixId, int walkLength, int numParts, int threshold, double keepProba, boolean isTrunc) {
        super(matrixId, partKey, updateClock);
        this.neighborMatrixId = neighborMatrixId;
        this.walkLength = walkLength;
        this.numParts = numParts;
        this.threshold = threshold;
        this.keepProba = keepProba;
        this.isTrunc = isTrunc;
    }

    public InitWalkPathPartitionParam(int matrixId, PartitionKey partKey, int neighborMatrixId, int walkLength, int numParts, int threshold, double keepProba, boolean isTrunc) {
        this(matrixId, partKey, false, neighborMatrixId, walkLength, numParts, threshold, keepProba, isTrunc);
    }

    public InitWalkPathPartitionParam(int matrixId, PartitionKey partKey, int neighborMatrixId, int walkLength, int numParts) {
        this(matrixId, partKey, false, neighborMatrixId, walkLength, numParts, -1, 1.0, false);
    }

    public InitWalkPathPartitionParam() {
    }

    public int getNeighborMatrixId() {
        return this.neighborMatrixId;
    }

    public int getWalkLength() {
        return this.walkLength;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public double getKeepProba() {
        return this.keepProba;
    }

    public void setKeepProba(double keepProba) {
        this.keepProba = keepProba;
    }

    public int getNumParts() {
        return this.numParts;
    }

    public void setNumParts(int numParts) {
        this.numParts = numParts;
    }

    public boolean isTrunc() {
        return this.isTrunc;
    }

    public void setTrunc(boolean trunc) {
        this.isTrunc = trunc;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.neighborMatrixId);
        buf.writeInt(this.walkLength);
        buf.writeInt(this.numParts);
        buf.writeInt(this.threshold);
        buf.writeDouble(this.keepProba);
        if (this.isTrunc) {
            buf.writeInt(1);
        } else {
            buf.writeInt(0);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.neighborMatrixId = buf.readInt();
        this.walkLength = buf.readInt();
        this.numParts = buf.readInt();
        this.threshold = buf.readInt();
        this.keepProba = buf.readDouble();
        this.isTrunc = buf.readInt() == 1;
    }

    public int bufferLen() {
        int len = super.bufferLen();
        return len + 28;
    }
}

