/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.updatefuncs.pushneighbor;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.graph.client.node2vec.updatefuncs.pushneighbor.PushNeighborPartitionParam;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PushNeighborParam
extends UpdateParam {
    private long[] keyIds;
    private Long2ObjectOpenHashMap<long[]> nodeIdToNeighborIndices;

    public PushNeighborParam(int matrixId, boolean updateClock, Long2ObjectOpenHashMap<long[]> adjTable) {
        super(matrixId, updateClock);
        this.nodeIdToNeighborIndices = adjTable;
        this.keyIds = adjTable.keySet().toLongArray();
        Arrays.sort(this.keyIds);
    }

    public PushNeighborParam(int matrixId, Long2ObjectOpenHashMap<long[]> adjTable) {
        this(matrixId, false, adjTable);
    }

    public List<PartitionUpdateParam> split() {
        List parts = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        ArrayList<PartitionUpdateParam> partParams = new ArrayList<PartitionUpdateParam>(parts.size());
        int count = 0;
        int nodeIndex = 0;
        for (PartitionKey part : parts) {
            int start = nodeIndex;
            while (nodeIndex < this.keyIds.length && this.keyIds[nodeIndex] < part.getEndCol()) {
                ++nodeIndex;
            }
            int end = nodeIndex;
            int sizePart = end - start;
            count += sizePart;
            if (sizePart <= 0) continue;
            partParams.add(new PushNeighborPartitionParam(this.matrixId, part, this.nodeIdToNeighborIndices, this.keyIds, start, end));
        }
        assert (count == this.nodeIdToNeighborIndices.size());
        return partParams;
    }
}

