/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.updatefuncs.pushneighbor;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.graph.client.node2vec.utils.SerDe;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PushNeighborPartitionParam
extends PartitionUpdateParam {
    private long[] keyIds;
    private int startIdx;
    private int endIdx;
    private Long2ObjectOpenHashMap<long[]> nodeIdToNeighborIndices;

    public PushNeighborPartitionParam(int matrixId, PartitionKey partKey, Long2ObjectOpenHashMap<long[]> nodeIdToNeighborIndices, long[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, partKey, false);
        this.keyIds = nodeIds;
        this.startIdx = startIndex;
        this.endIdx = endIndex;
        this.nodeIdToNeighborIndices = nodeIdToNeighborIndices;
    }

    public PushNeighborPartitionParam() {
    }

    public Long2ObjectOpenHashMap<long[]> getNodeIdToNeighborIndices() {
        return this.nodeIdToNeighborIndices;
    }

    protected void clear() {
        this.keyIds = null;
        this.startIdx = -1;
        this.endIdx = -1;
        this.nodeIdToNeighborIndices = null;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        SerDe.serLong2ArrayHashMap(this.keyIds, this.startIdx, this.endIdx, this.nodeIdToNeighborIndices, buf);
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.nodeIdToNeighborIndices = SerDe.deserLong2LongArray(buf);
    }

    public int bufferLen() {
        int len = super.bufferLen();
        return len += SerDe.getLong2ArrayHashMapSerSize(this.keyIds, this.startIdx, this.endIdx, this.nodeIdToNeighborIndices);
    }
}

