/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.updatefuncs.pushpathtail;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.node2vec.updatefuncs.pushpathtail.PushPathTailPartitionParam;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PushPathTailParam
extends UpdateParam {
    private Long2LongOpenHashMap pathTail;
    private long[] keyIds;

    public PushPathTailParam(int matrixId, boolean updateClock, Long2LongOpenHashMap pathTail) {
        super(matrixId, updateClock);
        this.pathTail = pathTail;
        this.keyIds = new long[pathTail.size()];
        LongIterator iter = pathTail.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.keyIds[i] = iter.nextLong();
            ++i;
        }
        assert (i == this.keyIds.length);
        Arrays.sort(this.keyIds);
    }

    public PushPathTailParam(int matrixId, Long2LongOpenHashMap pathTail) {
        this(matrixId, false, pathTail);
    }

    public List<PartitionUpdateParam> split() {
        List parts = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        ArrayList<PartitionUpdateParam> partParams = new ArrayList<PartitionUpdateParam>(parts.size());
        if (!RowUpdateSplitUtils.isInRange((long[])this.keyIds, (List)parts)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)parts.get(0)).getStartCol() + ", " + ((PartitionKey)parts.get(parts.size() - 1)).getEndCol());
        }
        int nodeIndex = 0;
        for (PartitionKey part : parts) {
            int start = nodeIndex;
            while (nodeIndex < this.keyIds.length && this.keyIds[nodeIndex] < part.getEndCol()) {
                ++nodeIndex;
            }
            int end = nodeIndex;
            int sizePart = end - start;
            if (sizePart <= 0) continue;
            partParams.add(new PushPathTailPartitionParam(this.matrixId, part, this.pathTail, this.keyIds, start, end));
        }
        return partParams;
    }
}

