/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.updatefuncs.pushpathtail;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;

public class PushPathTailPartitionParam
extends PartitionUpdateParam {
    private long[] keyIds;
    private int startIdx;
    private int endIdx;
    private Long2LongOpenHashMap pathTail;

    public PushPathTailPartitionParam(int matrixId, PartitionKey partKey, Long2LongOpenHashMap pathTail, long[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, partKey, false);
        this.keyIds = nodeIds;
        this.startIdx = startIndex;
        this.endIdx = endIndex;
        this.pathTail = pathTail;
    }

    public PushPathTailPartitionParam() {
    }

    public Long2LongOpenHashMap getPathTail() {
        return this.pathTail;
    }

    public void setPathTail(Long2LongOpenHashMap pathTail) {
        this.pathTail = pathTail;
    }

    protected void clear() {
        this.keyIds = null;
        this.startIdx = 0;
        this.endIdx = 0;
        this.pathTail = null;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int size = this.endIdx - this.startIdx;
        buf.writeInt(size);
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            long key = this.keyIds[i];
            buf.writeLong(key);
            buf.writeLong(this.pathTail.get(key));
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.startIdx = 0;
        this.endIdx = buf.readInt();
        int size = this.endIdx - this.startIdx;
        this.pathTail = new Long2LongOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            long key = buf.readLong();
            long value = buf.readLong();
            this.pathTail.put(key, value);
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        return len += 16 * (this.endIdx - this.startIdx) + 4;
    }
}

