/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.node2vec.utils;

import com.tencent.angel.graph.client.node2vec.data.WalkPath;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;

public class PathQueue {
    private static Int2ObjectOpenHashMap<Queue<WalkPath>> psPartId2Queue = new Int2ObjectOpenHashMap();
    private static Int2ObjectOpenHashMap<ReentrantLock> psPartId2Lock = new Int2ObjectOpenHashMap();
    private static Int2IntOpenHashMap progress = new Int2IntOpenHashMap();
    private static int numParts = -1;
    private static int threshold = -1;
    private static double keepProba = 0.0;
    private static boolean isTrunc = false;

    public static synchronized void init(int psPartId) {
        if (!psPartId2Queue.containsKey(psPartId) || psPartId2Lock.get(psPartId) == null) {
            psPartId2Queue.put(psPartId, new LinkedList());
        } else {
            ((Queue)psPartId2Queue.get(psPartId)).clear();
        }
        if (!psPartId2Lock.containsKey(psPartId) || psPartId2Lock.get(psPartId) == null) {
            ReentrantLock lock = new ReentrantLock();
            psPartId2Lock.put(psPartId, (Object)lock);
        }
        progress.put(psPartId, 0);
    }

    public static synchronized void clear(int psPartId) {
        if (psPartId2Queue.containsKey(psPartId)) {
            ((Queue)psPartId2Queue.get(psPartId)).clear();
        }
        if (progress.containsKey(psPartId)) {
            progress.put(psPartId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPushBatch(int psPartId, List<WalkPath> paths) {
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            queue.addAll(paths);
        }
        finally {
            queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushBatch(int psPartId, ServerLongAnyRow row, Long2LongOpenHashMap pathTail) {
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        int completeCount = 0;
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            for (Map.Entry entry : pathTail.entrySet()) {
                long key = (Long)entry.getKey();
                long tail = (Long)entry.getValue();
                WalkPath wPath = (WalkPath)row.get(key);
                wPath.add2Path(tail);
                if (wPath.isComplete()) {
                    ++completeCount;
                    continue;
                }
                queue.add(wPath);
            }
            progress.put(psPartId, progress.get(psPartId) + completeCount);
        }
        finally {
            queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long2ObjectOpenHashMap<long[]> popBatchTail(int psPartId, int batchSize) {
        Long2ObjectOpenHashMap result;
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            result = new Long2ObjectOpenHashMap(batchSize);
            for (int count = 0; !queue.isEmpty() && count < batchSize; ++count) {
                WalkPath wPath = (WalkPath)queue.poll();
                result.put(wPath.getHead(), (Object)wPath.getTail2());
            }
        }
        finally {
            queueLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popBatchTail(int psPartId, int batchSize, Long2ObjectOpenHashMap<long[]> result) {
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            for (int count = 0; !queue.isEmpty() && count < batchSize; ++count) {
                WalkPath wPath = (WalkPath)queue.poll();
                result.put(wPath.getHead(), (Object)wPath.getTail2());
            }
        }
        finally {
            queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long2ObjectOpenHashMap<long[]> popBatchPath(int psPartId, int batchSize) {
        Long2ObjectOpenHashMap result;
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            result = new Long2ObjectOpenHashMap(batchSize);
            for (int count = 0; !queue.isEmpty() && count < batchSize; ++count) {
                WalkPath wPath = (WalkPath)queue.poll();
                result.put(wPath.getHead(), (Object)wPath.getPath());
            }
        }
        finally {
            queueLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popBatchPath(int psPartId, int batchSize, Long2ObjectOpenHashMap<long[]> result) {
        ReentrantLock queueLock = (ReentrantLock)psPartId2Lock.get(psPartId);
        queueLock.lock();
        try {
            Queue queue = (Queue)psPartId2Queue.get(psPartId);
            for (int count = 0; !queue.isEmpty() && count < batchSize; ++count) {
                WalkPath wPath = (WalkPath)queue.poll();
                result.put(wPath.getHead(), (Object)wPath.getPath());
            }
        }
        finally {
            queueLock.unlock();
        }
    }

    public static int getProgress(int psPartId) {
        return progress.get(psPartId);
    }

    public static int getThreshold() {
        return threshold;
    }

    public static synchronized void setThreshold(int threshold) {
        PathQueue.threshold = threshold;
    }

    public static double getKeepProba() {
        return keepProba;
    }

    public static synchronized void setKeepProba(double keepProba) {
        PathQueue.keepProba = keepProba;
    }

    public static boolean isIsTrunc() {
        return isTrunc;
    }

    public static synchronized void setIsTrunc(boolean isTrunc) {
        PathQueue.isTrunc = isTrunc;
    }

    public static int getNumParts() {
        return numParts;
    }

    public static synchronized void setNumParts(int numParts) {
        PathQueue.numParts = numParts;
    }
}

