/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.getedgefeats;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartGetEdgeFeatsResult
extends PartitionGetResult {
    private int partId;
    private Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToContents;

    public PartGetEdgeFeatsResult(int partId, Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToContents) {
        this.partId = partId;
        this.nodeIdToContents = nodeIdToContents;
    }

    public PartGetEdgeFeatsResult() {
        this(-1, null);
    }

    public int getPartId() {
        return this.partId;
    }

    public Long2ObjectOpenHashMap<IntFloatVector[]> getNodeIdToContents() {
        return this.nodeIdToContents;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToContents.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            ByteBufSerdeUtils.serializeIntFloatVectors((ByteBuf)output, (IntFloatVector[])((IntFloatVector[])entry.getValue()));
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToContents = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.nodeIdToContents.put(ByteBufSerdeUtils.deserializeLong((ByteBuf)input), (Object)ByteBufSerdeUtils.deserializeIntFloatVectors((ByteBuf)input));
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            len += 8;
            len += ByteBufSerdeUtils.serializedIntFloatVectorsLen((IntFloatVector[])((IntFloatVector[])entry.getValue()));
        }
        return len;
    }
}

