/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.getedgeweights;

import com.tencent.angel.exception.InvalidParameterException;
import com.tencent.angel.graph.client.psf.get.utils.GetFloatArrayAttrsResult;
import com.tencent.angel.graph.client.psf.get.utils.GetNodeAttrsParam;
import com.tencent.angel.graph.client.psf.get.utils.PartGetFloatArrayAttrsResult;
import com.tencent.angel.graph.data.GraphNode;
import com.tencent.angel.graph.utils.GraphMatrixUtils;
import com.tencent.angel.ml.matrix.psf.get.base.GeneralPartGetParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetFunc;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetResult;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import com.tencent.angel.psagent.matrix.transport.router.KeyPart;
import com.tencent.angel.psagent.matrix.transport.router.operator.ILongKeyPartOp;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;

public class GetEdgeWeights
extends GetFunc {
    public GetEdgeWeights(GetNodeAttrsParam param) {
        super((GetParam)param);
    }

    public GetEdgeWeights() {
        this(null);
    }

    public PartitionGetResult partitionGet(PartitionGetParam partParam) {
        GeneralPartGetParam param = (GeneralPartGetParam)partParam;
        KeyPart keyPart = param.getIndicesPart();
        switch (keyPart.getKeyType()) {
            case LONG: {
                long[] nodeIds = ((ILongKeyPartOp)keyPart).getKeys();
                ServerLongAnyRow row = GraphMatrixUtils.getPSLongKeyRow(this.psContext, param);
                Long2ObjectOpenHashMap nodeIdToWeights = new Long2ObjectOpenHashMap(nodeIds.length);
                for (long nodeId : nodeIds) {
                    float[] weights;
                    if (row.get(nodeId) == null || (weights = ((GraphNode)row.get(nodeId)).getWeights()) == null) continue;
                    nodeIdToWeights.put(nodeId, (Object)weights);
                }
                return new PartGetFloatArrayAttrsResult(param.getPartKey().getPartitionId(), (Long2ObjectOpenHashMap<float[]>)nodeIdToWeights);
            }
        }
        throw new InvalidParameterException("Unsupport index type " + keyPart.getKeyType());
    }

    public GetResult merge(List<PartitionGetResult> partResults) {
        Long2ObjectOpenHashMap nodeIdToWeights = new Long2ObjectOpenHashMap(((GetNodeAttrsParam)this.param).getNodeIds().length);
        for (PartitionGetResult partitionGetResult : partResults) {
            Long2ObjectOpenHashMap<float[]> partNodeIdToWeights = ((PartGetFloatArrayAttrsResult)partitionGetResult).getNodeIdToContents();
            if (partNodeIdToWeights == null) continue;
            nodeIdToWeights.putAll(partNodeIdToWeights);
        }
        return new GetFloatArrayAttrsResult((Long2ObjectOpenHashMap<float[]>)nodeIdToWeights);
    }
}

