/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.getneighbors;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartGetNeighborsResult
extends PartitionGetResult {
    private int partId;
    private Long2ObjectOpenHashMap<long[]> nodeIdToContents;

    public PartGetNeighborsResult(int partId, Long2ObjectOpenHashMap<long[]> nodeIdToContents) {
        this.partId = partId;
        this.nodeIdToContents = nodeIdToContents;
    }

    public PartGetNeighborsResult() {
        this(-1, null);
    }

    public int getPartId() {
        return this.partId;
    }

    public Long2ObjectOpenHashMap<long[]> getNodeIdToContents() {
        return this.nodeIdToContents;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToContents.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])((long[])entry.getValue()));
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToContents = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.nodeIdToContents.put(ByteBufSerdeUtils.deserializeLong((ByteBuf)input), (Object)ByteBufSerdeUtils.deserializeLongs((ByteBuf)input));
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            len += 8;
            len += ByteBufSerdeUtils.serializedLongsLen((long[])((long[])entry.getValue()));
        }
        return len;
    }
}

