/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.getnodefeats;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartGetNodeFeatsResult
extends PartitionGetResult {
    private int partId;
    private Long2ObjectOpenHashMap<IntFloatVector> nodeIdTofeats;

    public PartGetNodeFeatsResult(int partId, Long2ObjectOpenHashMap<IntFloatVector> nodeIdTofeats) {
        this.partId = partId;
        this.nodeIdTofeats = nodeIdTofeats;
    }

    public PartGetNodeFeatsResult() {
        this(-1, null);
    }

    public int getPartId() {
        return this.partId;
    }

    public Long2ObjectOpenHashMap<IntFloatVector> getNodeIdTofeats() {
        return this.nodeIdTofeats;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdTofeats.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdTofeats.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            ByteBufSerdeUtils.serializeVector((ByteBuf)output, (Vector)((Vector)entry.getValue()));
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdTofeats = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
            IntFloatVector nodeFeats = (IntFloatVector)ByteBufSerdeUtils.deserializeVector((ByteBuf)input);
            this.nodeIdTofeats.put(nodeId, (Object)nodeFeats);
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdTofeats.long2ObjectEntrySet()) {
            len += 8;
            len += ByteBufSerdeUtils.serializedVectorLen((Vector)((Vector)entry.getValue()));
        }
        return len;
    }
}

