/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.utils;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartGetFloatArrayAttrsResult
extends PartitionGetResult {
    private int partId;
    private Long2ObjectOpenHashMap<float[]> nodeIdToContents;

    public PartGetFloatArrayAttrsResult(int partId, Long2ObjectOpenHashMap<float[]> nodeIdToContents) {
        this.partId = partId;
        this.nodeIdToContents = nodeIdToContents;
    }

    public PartGetFloatArrayAttrsResult() {
        this(-1, null);
    }

    public int getPartId() {
        return this.partId;
    }

    public Long2ObjectOpenHashMap<float[]> getNodeIdToContents() {
        return this.nodeIdToContents;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToContents.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            ByteBufSerdeUtils.serializeFloats((ByteBuf)output, (float[])((float[])entry.getValue()));
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToContents = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.nodeIdToContents.put(ByteBufSerdeUtils.deserializeLong((ByteBuf)input), (Object)ByteBufSerdeUtils.deserializeFloats((ByteBuf)input));
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToContents.long2ObjectEntrySet()) {
            len += 8;
            len += ByteBufSerdeUtils.serializedFloatsLen((float[])((float[])entry.getValue()));
        }
        return len;
    }
}

