/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.get.utils;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import io.netty.buffer.ByteBuf;

public class PartGetNodeAttrsParam
extends PartitionGetParam {
    private long[] nodeIds;
    private int startIndex;
    private int endIndex;

    public PartGetNodeAttrsParam(int matrixId, PartitionKey part, long[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, part);
        this.nodeIds = nodeIds;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public PartGetNodeAttrsParam() {
        this(-1, null, null, -1, -1);
    }

    public long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        ByteBufSerdeUtils.serializeInt((ByteBuf)buf, (int)(this.endIndex - this.startIndex));
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)buf, (long)this.nodeIds[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.nodeIds = new long[ByteBufSerdeUtils.deserializeInt((ByteBuf)buf)];
        for (int i = 0; i < this.nodeIds.length; ++i) {
            this.nodeIds[i] = ByteBufSerdeUtils.deserializeLong((ByteBuf)buf);
        }
    }

    public int bufferLen() {
        return super.bufferLen() + 4 + 8 * (this.endIndex - this.startIndex);
    }
}

