/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.sample;

import com.tencent.angel.graph.client.psf.sample.sampleneighbor.SampleType;
import com.tencent.angel.graph.data.GraphNode;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import com.tencent.angel.ps.storage.vector.ServerRow;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Random;
import scala.Tuple2;
import scala.Tuple3;

public class SampleUtils {
    public static Long2ObjectOpenHashMap<long[]> sampleByCount(ServerRow row, int count, long[] nodeIds, long seed) {
        Random r = new Random(seed);
        Long2ObjectOpenHashMap nodeId2SampleNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        for (long nodeId : nodeIds) {
            long[] sampleNeighbors;
            GraphNode graphNode = (GraphNode)((ServerLongAnyRow)row).get(nodeId);
            if (graphNode == null) {
                sampleNeighbors = new long[]{};
            } else {
                long[] nodeNeighbors = graphNode.getNeighbors();
                if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                    sampleNeighbors = new long[]{};
                } else if (count <= 0 || nodeNeighbors.length <= count) {
                    sampleNeighbors = nodeNeighbors;
                } else {
                    sampleNeighbors = new long[count];
                    int startPos = Math.abs(r.nextInt()) % nodeNeighbors.length;
                    if (startPos + count <= nodeNeighbors.length) {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, count);
                    } else {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, nodeNeighbors.length - startPos);
                        System.arraycopy(nodeNeighbors, 0, sampleNeighbors, nodeNeighbors.length - startPos, count - (nodeNeighbors.length - startPos));
                    }
                }
            }
            nodeId2SampleNeighbors.put(nodeId, (Object)sampleNeighbors);
        }
        return nodeId2SampleNeighbors;
    }

    public static Tuple2<Long2ObjectOpenHashMap<long[]>, Long2ObjectOpenHashMap<int[]>> sampleWithType(ServerRow row, int count, long[] nodeIds, SampleType sampleType, long seed) {
        Random r = new Random(seed);
        Long2ObjectOpenHashMap nodeId2SampleNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        Long2ObjectOpenHashMap nodeId2SampleNeighborsType = new Long2ObjectOpenHashMap(nodeIds.length);
        for (long nodeId : nodeIds) {
            int[] neighborsTypes;
            long[] sampleNeighbors;
            GraphNode graphNode = (GraphNode)((ServerLongAnyRow)row).get(nodeId);
            if (graphNode == null) {
                sampleNeighbors = new long[]{};
                neighborsTypes = new int[]{};
            } else {
                long[] nodeNeighbors = graphNode.getNeighbors();
                int[] nodeNeighborsTypes = sampleType == SampleType.NODE ? graphNode.getTypes() : graphNode.getEdgeTypes();
                if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                    sampleNeighbors = new long[]{};
                    neighborsTypes = new int[]{};
                } else if (count <= 0 || nodeNeighbors.length <= count) {
                    sampleNeighbors = nodeNeighbors;
                    neighborsTypes = nodeNeighborsTypes == null || nodeNeighborsTypes.length == 0 ? new int[]{} : nodeNeighborsTypes;
                } else {
                    sampleNeighbors = new long[count];
                    neighborsTypes = new int[count];
                    int startPos = Math.abs(r.nextInt()) % nodeNeighbors.length;
                    if (startPos + count <= nodeNeighbors.length) {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, count);
                        System.arraycopy(nodeNeighborsTypes, startPos, neighborsTypes, 0, count);
                    } else {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, nodeNeighbors.length - startPos);
                        System.arraycopy(nodeNeighbors, 0, sampleNeighbors, nodeNeighbors.length - startPos, count - (nodeNeighbors.length - startPos));
                        System.arraycopy(nodeNeighborsTypes, startPos, neighborsTypes, 0, nodeNeighborsTypes.length - startPos);
                        System.arraycopy(nodeNeighborsTypes, 0, neighborsTypes, nodeNeighborsTypes.length - startPos, count - (nodeNeighborsTypes.length - startPos));
                    }
                }
            }
            nodeId2SampleNeighbors.put(nodeId, (Object)sampleNeighbors);
            nodeId2SampleNeighborsType.put(nodeId, (Object)neighborsTypes);
        }
        return new Tuple2((Object)nodeId2SampleNeighbors, (Object)nodeId2SampleNeighborsType);
    }

    public static Tuple2<Long2ObjectOpenHashMap<long[]>, Long2ObjectOpenHashMap<int[]>> sampleWithType(ServerRow row, long[] nodeIds, SampleType sampleType, long[] filterWithNeighKeys, long[] filterWithoutNeighKeys, long seed) {
        Long2ObjectOpenHashMap nodeId2SampleNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        Long2ObjectOpenHashMap nodeId2SampleNeighborsType = new Long2ObjectOpenHashMap(nodeIds.length);
        for (int i = 0; i < nodeIds.length; ++i) {
            ArrayList<Integer> neighborsTypes;
            ArrayList<Long> sampleNeighbors;
            GraphNode graphNode = (GraphNode)((ServerLongAnyRow)row).get(nodeIds[i]);
            if (graphNode == null) {
                sampleNeighbors = new ArrayList<Long>();
                neighborsTypes = new ArrayList<Integer>();
            } else {
                long[] nodeNeighbors = graphNode.getNeighbors();
                int[] nodeNeighborsTypes = sampleType == SampleType.NODE ? graphNode.getTypes() : graphNode.getEdgeTypes();
                if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                    sampleNeighbors = new ArrayList();
                    neighborsTypes = new ArrayList();
                } else {
                    sampleNeighbors = new ArrayList();
                    neighborsTypes = new ArrayList();
                    for (int j = 0; j < nodeNeighbors.length; ++j) {
                        if (filterWithoutNeighKeys != null && nodeNeighbors[j] != filterWithoutNeighKeys[i]) {
                            sampleNeighbors.add(nodeNeighbors[j]);
                            neighborsTypes.add(nodeNeighborsTypes[j]);
                        } else if (filterWithoutNeighKeys == null && !sampleNeighbors.contains(nodeNeighbors[j])) {
                            sampleNeighbors.add(nodeNeighbors[j]);
                            neighborsTypes.add(nodeNeighborsTypes[j]);
                        }
                        if (filterWithNeighKeys != null) {
                            for (int k = 0; k < filterWithNeighKeys.length; ++k) {
                                if (nodeNeighbors[j] != filterWithNeighKeys[k] || sampleNeighbors.contains(filterWithNeighKeys[k])) continue;
                                sampleNeighbors.add(nodeNeighbors[j]);
                                neighborsTypes.add(nodeNeighborsTypes[j]);
                            }
                            continue;
                        }
                        if (sampleNeighbors.contains(nodeNeighbors[j])) continue;
                        sampleNeighbors.add(nodeNeighbors[j]);
                        neighborsTypes.add(nodeNeighborsTypes[j]);
                    }
                }
            }
            nodeId2SampleNeighbors.put(nodeIds[i], (Object)sampleNeighbors.stream().mapToLong(x -> x).toArray());
            nodeId2SampleNeighborsType.put(nodeIds[i], (Object)neighborsTypes.stream().mapToInt(x -> x).toArray());
        }
        return new Tuple2((Object)nodeId2SampleNeighbors, (Object)nodeId2SampleNeighborsType);
    }

    public static Tuple3<Long2ObjectOpenHashMap<long[]>, Long2ObjectOpenHashMap<int[]>, Long2ObjectOpenHashMap<int[]>> sampleWithBothType(ServerRow row, int count, long[] nodeIds, long seed) {
        Random r = new Random(seed);
        Long2ObjectOpenHashMap nodeId2SampleNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        Long2ObjectOpenHashMap nodeId2SampleNeighborsType = new Long2ObjectOpenHashMap(nodeIds.length);
        Long2ObjectOpenHashMap nodeId2SampleEdgeType = new Long2ObjectOpenHashMap(nodeIds.length);
        for (long nodeId : nodeIds) {
            int[] edgeTypes;
            int[] neighborsTypes;
            long[] sampleNeighbors;
            GraphNode graphNode = (GraphNode)((ServerLongAnyRow)row).get(nodeId);
            if (graphNode == null) {
                sampleNeighbors = new long[]{};
                neighborsTypes = new int[]{};
                edgeTypes = new int[]{};
            } else {
                long[] nodeNeighbors = graphNode.getNeighbors();
                int[] nodeNeighborsTypes = graphNode.getTypes();
                int[] nodeEdgeTypes = graphNode.getEdgeTypes();
                if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                    sampleNeighbors = new long[]{};
                    neighborsTypes = new int[]{};
                    edgeTypes = new int[]{};
                } else if (count <= 0 || nodeNeighbors.length <= count) {
                    sampleNeighbors = nodeNeighbors;
                    neighborsTypes = nodeNeighborsTypes == null || nodeNeighborsTypes.length == 0 ? new int[]{} : nodeNeighborsTypes;
                    edgeTypes = nodeEdgeTypes == null || nodeEdgeTypes.length == 0 ? new int[]{} : nodeEdgeTypes;
                } else {
                    sampleNeighbors = new long[count];
                    neighborsTypes = new int[count];
                    edgeTypes = new int[count];
                    int startPos = Math.abs(r.nextInt()) % nodeNeighbors.length;
                    if (startPos + count <= nodeNeighbors.length) {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, count);
                        System.arraycopy(nodeNeighborsTypes, startPos, neighborsTypes, 0, count);
                        System.arraycopy(nodeEdgeTypes, startPos, edgeTypes, 0, count);
                    } else {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, nodeNeighbors.length - startPos);
                        System.arraycopy(nodeNeighbors, 0, sampleNeighbors, nodeNeighbors.length - startPos, count - (nodeNeighbors.length - startPos));
                        System.arraycopy(nodeNeighborsTypes, startPos, neighborsTypes, 0, nodeNeighborsTypes.length - startPos);
                        System.arraycopy(nodeNeighborsTypes, 0, neighborsTypes, nodeNeighborsTypes.length - startPos, count - (nodeNeighborsTypes.length - startPos));
                        System.arraycopy(nodeEdgeTypes, startPos, edgeTypes, 0, nodeEdgeTypes.length - startPos);
                        System.arraycopy(nodeEdgeTypes, 0, edgeTypes, nodeEdgeTypes.length - startPos, count - (nodeEdgeTypes.length - startPos));
                    }
                }
            }
            nodeId2SampleNeighbors.put(nodeId, (Object)sampleNeighbors);
            nodeId2SampleNeighborsType.put(nodeId, (Object)neighborsTypes);
            nodeId2SampleEdgeType.put(nodeId, (Object)edgeTypes);
        }
        return new Tuple3((Object)nodeId2SampleNeighbors, (Object)nodeId2SampleNeighborsType, (Object)nodeId2SampleEdgeType);
    }

    public static IntFloatVector[] sampleNodeFeatByCount(ServerRow row, int count, long seed) {
        Random r = new Random(seed);
        IntFloatVector[] feats = new IntFloatVector[count];
        int bound = row.size() - count;
        int skip = bound > 0 ? r.nextInt(bound) : 0;
        ObjectIterator it = ((ServerLongAnyRow)row).getStorage().iterator();
        it.skip(skip);
        for (int i = 0; i < count; ++i) {
            feats[i] = ((GraphNode)((Long2ObjectMap.Entry)it.next()).getValue()).getFeats();
        }
        return feats;
    }

    public static Tuple2<Long2ObjectOpenHashMap<long[]>, Long2ObjectOpenHashMap<IntFloatVector[]>> sampleEdgeFeat(ServerRow row, int count, long[] nodeIds, long seed) {
        Random r = new Random(seed);
        Long2ObjectOpenHashMap nodeId2SampleNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        Long2ObjectOpenHashMap nodeId2SampleEdgeFeats = new Long2ObjectOpenHashMap(nodeIds.length);
        for (long nodeId : nodeIds) {
            IntFloatVector[] edgeFeats;
            long[] sampleNeighbors;
            GraphNode graphNode = (GraphNode)((ServerLongAnyRow)row).get(nodeId);
            if (graphNode == null) {
                sampleNeighbors = new long[]{};
                edgeFeats = new IntFloatVector[]{};
            } else {
                long[] nodeNeighbors = graphNode.getNeighbors();
                IntFloatVector[] nodeEdgeFeats = graphNode.getEdgeFeatures();
                if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                    sampleNeighbors = new long[]{};
                    edgeFeats = new IntFloatVector[]{};
                } else if (count <= 0 || nodeNeighbors.length <= count) {
                    sampleNeighbors = nodeNeighbors;
                    edgeFeats = nodeEdgeFeats == null || nodeEdgeFeats.length == 0 ? new IntFloatVector[]{} : nodeEdgeFeats;
                } else {
                    sampleNeighbors = new long[count];
                    edgeFeats = new IntFloatVector[count];
                    int startPos = Math.abs(r.nextInt()) % nodeNeighbors.length;
                    if (startPos + count <= nodeNeighbors.length) {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, count);
                        System.arraycopy(nodeEdgeFeats, startPos, edgeFeats, 0, count);
                    } else {
                        System.arraycopy(nodeNeighbors, startPos, sampleNeighbors, 0, nodeNeighbors.length - startPos);
                        System.arraycopy(nodeNeighbors, 0, sampleNeighbors, nodeNeighbors.length - startPos, count - (nodeNeighbors.length - startPos));
                        System.arraycopy(nodeEdgeFeats, startPos, edgeFeats, 0, nodeEdgeFeats.length - startPos);
                        System.arraycopy(nodeEdgeFeats, 0, edgeFeats, nodeEdgeFeats.length - startPos, count - (nodeEdgeFeats.length - startPos));
                    }
                }
            }
            nodeId2SampleNeighbors.put(nodeId, (Object)sampleNeighbors);
            nodeId2SampleEdgeFeats.put(nodeId, (Object)edgeFeats);
        }
        return new Tuple2((Object)nodeId2SampleNeighbors, (Object)nodeId2SampleEdgeFeats);
    }
}

