/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.sample.sampleedgefeats;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.graph.client.constent.Constent;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartSampleEdgeFeatResult
extends PartitionGetResult {
    public int partId;
    public Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors;
    public Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToSampleEdgeFeats;

    public PartSampleEdgeFeatResult(int partId, Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors, Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToSampleEdgeFeats) {
        this.partId = partId;
        this.nodeIdToSampleNeighbors = nodeIdToSampleNeighbors;
        this.nodeIdToSampleEdgeFeats = nodeIdToSampleEdgeFeats;
    }

    public PartSampleEdgeFeatResult() {
        this(-1, null, null);
    }

    public Long2ObjectOpenHashMap<long[]> getNodeIdToSampleNeighbors() {
        return this.nodeIdToSampleNeighbors;
    }

    public void setNodeIdToSampleNeighbors(Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors) {
        this.nodeIdToSampleNeighbors = nodeIdToSampleNeighbors;
    }

    public Long2ObjectOpenHashMap<IntFloatVector[]> getNodeIdToSampleEdgeFeats() {
        return this.nodeIdToSampleEdgeFeats;
    }

    public void setNodeIdToSampleEdgeFeats(Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToSampleEdgeFeats) {
        this.nodeIdToSampleEdgeFeats = nodeIdToSampleEdgeFeats;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleNeighbors.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])Constent.emptyLongs);
                continue;
            }
            ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])sampleNeighbors);
        }
        if (this.nodeIdToSampleEdgeFeats != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleEdgeFeats.size());
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleEdgeFeats.long2ObjectEntrySet()) {
                ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
                IntFloatVector[] sampleEdgeFeats = (IntFloatVector[])entry.getValue();
                if (sampleEdgeFeats == null) {
                    ByteBufSerdeUtils.serializeIntFloatVectors((ByteBuf)output, (IntFloatVector[])Constent.emptyIntFloatVectors);
                    continue;
                }
                ByteBufSerdeUtils.serializeIntFloatVectors((ByteBuf)output, (IntFloatVector[])sampleEdgeFeats);
            }
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToSampleNeighbors = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
            long[] sampleNeighbors = ByteBufSerdeUtils.deserializeLongs((ByteBuf)input);
            this.nodeIdToSampleNeighbors.put(nodeId, (Object)sampleNeighbors);
        }
        int nodeTypeSize = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        if (nodeTypeSize > 0) {
            this.nodeIdToSampleEdgeFeats = new Long2ObjectOpenHashMap(nodeTypeSize);
            for (int i = 0; i < nodeTypeSize; ++i) {
                long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
                IntFloatVector[] sampleEdgeFeats = ByteBufSerdeUtils.deserializeIntFloatVectors((ByteBuf)input);
                this.nodeIdToSampleEdgeFeats.put(nodeId, (Object)sampleEdgeFeats);
            }
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            len += 8;
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                len += ByteBufSerdeUtils.serializedLongsLen((long[])Constent.emptyLongs);
                continue;
            }
            len += ByteBufSerdeUtils.serializedLongsLen((long[])sampleNeighbors);
        }
        len += 4;
        if (this.nodeIdToSampleEdgeFeats != null) {
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleEdgeFeats.long2ObjectEntrySet()) {
                len += 8;
                IntFloatVector[] sampleEdgeFeats = (IntFloatVector[])entry.getValue();
                if (sampleEdgeFeats == null) {
                    len += ByteBufSerdeUtils.serializedIntFloatVectorsLen((IntFloatVector[])Constent.emptyIntFloatVectors);
                    continue;
                }
                len += ByteBufSerdeUtils.serializedIntFloatVectorsLen((IntFloatVector[])sampleEdgeFeats);
            }
        }
        return len;
    }
}

