/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.sample.sampleneighbor;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.graph.client.constent.Constent;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartSampleNeighborResult
extends PartitionGetResult {
    public int partId;
    public Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors;

    public PartSampleNeighborResult(int partId, Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors) {
        this.partId = partId;
        this.nodeIdToSampleNeighbors = nodeIdToSampleNeighbors;
    }

    public PartSampleNeighborResult() {
        this(-1, null);
    }

    public Long2ObjectOpenHashMap<long[]> getNodeIdToSampleNeighbors() {
        return this.nodeIdToSampleNeighbors;
    }

    public void setNodeIdToSampleNeighbors(Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors) {
        this.nodeIdToSampleNeighbors = nodeIdToSampleNeighbors;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleNeighbors.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])Constent.emptyLongs);
                continue;
            }
            ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])sampleNeighbors);
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToSampleNeighbors = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
            long[] sampleNeighbors = ByteBufSerdeUtils.deserializeLongs((ByteBuf)input);
            this.nodeIdToSampleNeighbors.put(nodeId, (Object)sampleNeighbors);
        }
    }

    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            len += 8;
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                len += ByteBufSerdeUtils.serializedLongsLen((long[])Constent.emptyLongs);
                continue;
            }
            len += ByteBufSerdeUtils.serializedLongsLen((long[])sampleNeighbors);
        }
        return len;
    }
}

