/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.sample.sampleneighbor;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.graph.client.constent.Constent;
import com.tencent.angel.graph.client.psf.sample.sampleneighbor.PartSampleNeighborResult;
import com.tencent.angel.graph.client.psf.sample.sampleneighbor.SampleType;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class PartSampleNeighborResultWithType
extends PartSampleNeighborResult {
    private Long2ObjectOpenHashMap<int[]> nodeIdToSampleNeighborsType;
    private Long2ObjectOpenHashMap<int[]> nodeIdToSampleEdgeType;

    public PartSampleNeighborResultWithType(int partId, Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors, Long2ObjectOpenHashMap<int[]> nodeIdToType, SampleType sampleType) {
        super(partId, nodeIdToSampleNeighbors);
        if (sampleType == SampleType.NODE) {
            this.nodeIdToSampleNeighborsType = nodeIdToType;
        } else if (sampleType == SampleType.EDGE) {
            this.nodeIdToSampleEdgeType = nodeIdToType;
        }
    }

    public PartSampleNeighborResultWithType(int partId, Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors, Long2ObjectOpenHashMap<int[]> nodeIdToSampleNeighborsType, Long2ObjectOpenHashMap<int[]> nodeIdToSampleEdgeType) {
        super(partId, nodeIdToSampleNeighbors);
        this.nodeIdToSampleNeighborsType = nodeIdToSampleNeighborsType;
        this.nodeIdToSampleEdgeType = nodeIdToSampleEdgeType;
    }

    public PartSampleNeighborResultWithType() {
        this(-1, null, null, SampleType.SIMPLE);
    }

    @Override
    public Long2ObjectOpenHashMap<long[]> getNodeIdToSampleNeighbors() {
        return this.nodeIdToSampleNeighbors;
    }

    @Override
    public void setNodeIdToSampleNeighbors(Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors) {
        this.nodeIdToSampleNeighbors = nodeIdToSampleNeighbors;
    }

    public Long2ObjectOpenHashMap<int[]> getNodeIdToSampleNeighborsType() {
        return this.nodeIdToSampleNeighborsType;
    }

    public void setNodeIdToSampleNeighborsType(Long2ObjectOpenHashMap<int[]> nodeIdToSampleNeighborsType) {
        this.nodeIdToSampleNeighborsType = nodeIdToSampleNeighborsType;
    }

    public Long2ObjectOpenHashMap<int[]> getNodeIdToSampleEdgeType() {
        return this.nodeIdToSampleEdgeType;
    }

    public void setNodeIdToSampleEdgeType(Long2ObjectOpenHashMap<int[]> nodeIdToSampleEdgeType) {
        this.nodeIdToSampleEdgeType = nodeIdToSampleEdgeType;
    }

    @Override
    public int getPartId() {
        return this.partId;
    }

    @Override
    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleNeighbors.size());
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])Constent.emptyLongs);
                continue;
            }
            ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])sampleNeighbors);
        }
        if (this.nodeIdToSampleNeighborsType != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleNeighborsType.size());
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighborsType.long2ObjectEntrySet()) {
                ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
                int[] sampleNeighborsType = (int[])entry.getValue();
                if (sampleNeighborsType == null) {
                    ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])Constent.emptyInts);
                    continue;
                }
                ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])sampleNeighborsType);
            }
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.nodeIdToSampleEdgeType != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.nodeIdToSampleEdgeType.size());
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleEdgeType.long2ObjectEntrySet()) {
                ByteBufSerdeUtils.serializeLong((ByteBuf)output, (long)entry.getLongKey());
                int[] sampleEdgeType = (int[])entry.getValue();
                if (sampleEdgeType == null) {
                    ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])Constent.emptyInts);
                    continue;
                }
                ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])sampleEdgeType);
            }
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
    }

    @Override
    public void deserialize(ByteBuf input) {
        int nodeEdgeSize;
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.nodeIdToSampleNeighbors = new Long2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
            long[] sampleNeighbors = ByteBufSerdeUtils.deserializeLongs((ByteBuf)input);
            this.nodeIdToSampleNeighbors.put(nodeId, (Object)sampleNeighbors);
        }
        int nodeTypeSize = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        if (nodeTypeSize > 0) {
            this.nodeIdToSampleNeighborsType = new Long2ObjectOpenHashMap(nodeTypeSize);
            for (int i = 0; i < nodeTypeSize; ++i) {
                long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
                int[] sampleNeighborsType = ByteBufSerdeUtils.deserializeInts((ByteBuf)input);
                this.nodeIdToSampleNeighborsType.put(nodeId, (Object)sampleNeighborsType);
            }
        }
        if ((nodeEdgeSize = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.nodeIdToSampleEdgeType = new Long2ObjectOpenHashMap(nodeEdgeSize);
            for (int i = 0; i < nodeEdgeSize; ++i) {
                long nodeId = ByteBufSerdeUtils.deserializeLong((ByteBuf)input);
                int[] sampleEdgeType = ByteBufSerdeUtils.deserializeInts((ByteBuf)input);
                this.nodeIdToSampleEdgeType.put(nodeId, (Object)sampleEdgeType);
            }
        }
    }

    @Override
    public int bufferLen() {
        int len = 8;
        for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighbors.long2ObjectEntrySet()) {
            len += 8;
            long[] sampleNeighbors = (long[])entry.getValue();
            if (sampleNeighbors == null) {
                len += ByteBufSerdeUtils.serializedLongsLen((long[])Constent.emptyLongs);
                continue;
            }
            len += ByteBufSerdeUtils.serializedLongsLen((long[])sampleNeighbors);
        }
        len += 4;
        if (this.nodeIdToSampleNeighborsType != null) {
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleNeighborsType.long2ObjectEntrySet()) {
                len += 8;
                int[] sampleNeighborsType = (int[])entry.getValue();
                if (sampleNeighborsType == null) {
                    len += ByteBufSerdeUtils.serializedIntsLen((int[])Constent.emptyInts);
                    continue;
                }
                len += ByteBufSerdeUtils.serializedIntsLen((int[])sampleNeighborsType);
            }
        }
        len += 4;
        if (this.nodeIdToSampleEdgeType != null) {
            for (Long2ObjectMap.Entry entry : this.nodeIdToSampleEdgeType.long2ObjectEntrySet()) {
                len += 8;
                int[] sampleEdgeType = (int[])entry.getValue();
                if (sampleEdgeType == null) {
                    len += ByteBufSerdeUtils.serializedIntsLen((int[])Constent.emptyInts);
                    continue;
                }
                len += ByteBufSerdeUtils.serializedIntsLen((int[])sampleEdgeType);
            }
        }
        return len;
    }
}

