/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.psf.sample.samplenodefeats;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;

public class PartSampleNodeFeatResult
extends PartitionGetResult {
    public int partId;
    public IntFloatVector[] feats;

    public PartSampleNodeFeatResult(int partId, IntFloatVector[] feats) {
        this.partId = partId;
        this.feats = feats;
    }

    public PartSampleNodeFeatResult() {
        this(-1, null);
    }

    public IntFloatVector[] getNodeFeats() {
        return this.feats;
    }

    public void setNodeFeats(IntFloatVector[] feats) {
        this.feats = feats;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.partId);
        ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.feats.length);
        for (IntFloatVector feat : this.feats) {
            if (feat == null) {
                ByteBufSerdeUtils.serializeBoolean((ByteBuf)output, (boolean)true);
                continue;
            }
            ByteBufSerdeUtils.serializeBoolean((ByteBuf)output, (boolean)false);
            ByteBufSerdeUtils.serializeVector((ByteBuf)output, (Vector)feat);
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        int size = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        this.feats = new IntFloatVector[size];
        for (int i = 0; i < size; ++i) {
            boolean isNull = ByteBufSerdeUtils.deserializeBoolean((ByteBuf)input);
            if (isNull) continue;
            this.feats[i] = (IntFloatVector)ByteBufSerdeUtils.deserializeVector((ByteBuf)input);
        }
    }

    public int bufferLen() {
        int len = 8;
        for (IntFloatVector feat : this.feats) {
            ++len;
            if (feat == null) continue;
            len += ByteBufSerdeUtils.serializedVectorLen((Vector)feat);
        }
        return len;
    }
}

