/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import io.netty.buffer.ByteBuf;

public class PartSampleNeighborParam
extends PartitionGetParam {
    private int[] nodeIds;
    private int count;
    private int startIndex;
    private int endIndex;

    public PartSampleNeighborParam(int matrixId, PartitionKey part, int count, int[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, part);
        this.nodeIds = nodeIds;
        this.count = count;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public PartSampleNeighborParam() {
        this(0, null, 0, null, 0, 0);
    }

    public int[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(int[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.endIndex - this.startIndex);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            buf.writeInt(this.nodeIds[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.count = buf.readInt();
        this.nodeIds = new int[buf.readInt()];
        for (int i = 0; i < this.nodeIds.length; ++i) {
            this.nodeIds[i] = buf.readInt();
        }
    }

    public int bufferLen() {
        return super.bufferLen() + 8 + 4 * (this.endIndex - this.startIndex);
    }
}

