/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor;

import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;

public class PartSampleNeighborResult
extends PartitionGetResult {
    private Int2ObjectOpenHashMap<int[]> nodeIdToNeighbors;

    public PartSampleNeighborResult(Int2ObjectOpenHashMap<int[]> nodeIdToNeighbors) {
        this.nodeIdToNeighbors = nodeIdToNeighbors;
    }

    public PartSampleNeighborResult() {
        this(null);
    }

    public Int2ObjectOpenHashMap<int[]> getNodeIdToNeighbors() {
        return this.nodeIdToNeighbors;
    }

    public void setNodeIdToNeighbors(Int2ObjectOpenHashMap<int[]> nodeIdToNeighbors) {
        this.nodeIdToNeighbors = nodeIdToNeighbors;
    }

    public void serialize(ByteBuf output) {
        output.writeInt(this.nodeIdToNeighbors.size());
        ObjectIterator iter = this.nodeIdToNeighbors.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            output.writeInt(entry.getIntKey());
            int[] values = (int[])entry.getValue();
            output.writeInt(values.length);
            for (int value : values) {
                output.writeInt(value);
            }
        }
    }

    public void deserialize(ByteBuf input) {
        int size = input.readInt();
        this.nodeIdToNeighbors = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            int nodeIndex = input.readInt();
            int[] neighbors = new int[input.readInt()];
            for (int j = 0; j < neighbors.length; ++j) {
                neighbors[j] = input.readInt();
            }
            this.nodeIdToNeighbors.put(nodeIndex, (Object)neighbors);
        }
    }

    public int bufferLen() {
        int len = 4;
        for (Map.Entry entry : this.nodeIdToNeighbors.entrySet()) {
            len += 8;
            len += ((int[])entry.getValue()).length * 4;
        }
        return len;
    }
}

