/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor;

import com.tencent.angel.graph.client.sampleneighbor.PartSampleNeighborParam;
import com.tencent.angel.graph.client.sampleneighbor.PartSampleNeighborResult;
import com.tencent.angel.graph.client.sampleneighbor.SampleNeighborParam;
import com.tencent.angel.graph.client.sampleneighbor.SampleNeighborResult;
import com.tencent.angel.ml.matrix.psf.get.base.GetFunc;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetResult;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.matrix.ServerMatrix;
import com.tencent.angel.ps.storage.partition.CSRPartition;
import com.tencent.angel.ps.storage.partition.storage.IntCSRStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;

public class SampleNeighbor
extends GetFunc {
    public SampleNeighbor(SampleNeighborParam param) {
        super((GetParam)param);
    }

    public SampleNeighbor() {
        this(null);
    }

    public PartitionGetResult partitionGet(PartitionGetParam partParam) {
        PartSampleNeighborParam param = (PartSampleNeighborParam)partParam;
        ServerMatrix matrix = this.psContext.getMatrixStorageManager().getMatrix(partParam.getMatrixId());
        CSRPartition part = (CSRPartition)matrix.getPartition(partParam.getPartKey().getPartitionId());
        IntCSRStorage storage = (IntCSRStorage)part.getStorage();
        Int2ObjectOpenHashMap results = new Int2ObjectOpenHashMap();
        int[] neighborOffsets = storage.getRowOffsets();
        int[] neighbors = storage.getColumnIndices();
        int startCol = (int)partParam.getPartKey().getStartCol();
        int[] nodeIds = param.getNodeIds();
        int count = param.getCount();
        Random r = new Random();
        for (int i = 0; i < nodeIds.length; ++i) {
            int[] result;
            int nodeId = nodeIds[i];
            int num = neighborOffsets[nodeId - startCol + 1] - neighborOffsets[nodeId - startCol];
            if (num == 0) {
                result = new int[]{};
            } else if (count <= 0 || num <= count) {
                result = new int[num];
                System.arraycopy(neighbors, neighborOffsets[nodeId - startCol], result, 0, num);
            } else {
                int startPos = Math.abs(r.nextInt()) % num;
                result = new int[count];
                if (startPos + count <= num) {
                    System.arraycopy(neighbors, neighborOffsets[nodeId - startCol] + startPos, result, 0, count);
                } else {
                    System.arraycopy(neighbors, neighborOffsets[nodeId - startCol] + startPos, result, 0, num - startPos);
                    System.arraycopy(neighbors, neighborOffsets[nodeId - startCol], result, num - startPos, count - (num - startPos));
                }
            }
            results.put(nodeIds[i], (Object)result);
        }
        return new PartSampleNeighborResult((Int2ObjectOpenHashMap<int[]>)results);
    }

    public GetResult merge(List<PartitionGetResult> partResults) {
        int len = 0;
        for (PartitionGetResult result : partResults) {
            len += ((PartSampleNeighborResult)result).getNodeIdToNeighbors().size();
        }
        Int2ObjectOpenHashMap nodeIdToNeighbors = new Int2ObjectOpenHashMap(len);
        for (PartitionGetResult result : partResults) {
            nodeIdToNeighbors.putAll(((PartSampleNeighborResult)result).getNodeIdToNeighbors());
        }
        return new SampleNeighborResult((Int2ObjectOpenHashMap<int[]>)nodeIdToNeighbors);
    }
}

