/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.sampleneighbor.PartSampleNeighborParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SampleNeighborParam
extends GetParam {
    private int[] nodeIds;
    private int count;

    public SampleNeighborParam(int matrixId, int[] nodeIds, int count) {
        super(matrixId);
        this.nodeIds = nodeIds;
        this.count = count;
    }

    public SampleNeighborParam() {
        this(-1, null, -1);
    }

    public List<PartitionGetParam> split() {
        Arrays.sort(this.nodeIds);
        ArrayList<PartitionGetParam> partParams = new ArrayList<PartitionGetParam>();
        List partitions = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        if (!RowUpdateSplitUtils.isInRange((int[])this.nodeIds, (List)partitions)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)partitions.get(0)).getStartCol() + ", " + ((PartitionKey)partitions.get(partitions.size() - 1)).getEndCol());
        }
        int nodeIndex = 0;
        for (int partIndex = 0; nodeIndex < this.nodeIds.length || partIndex < partitions.size(); ++partIndex) {
            int length = 0;
            int endOffset = (int)((PartitionKey)partitions.get(partIndex)).getEndCol();
            while (nodeIndex < this.nodeIds.length && this.nodeIds[nodeIndex] < endOffset) {
                ++nodeIndex;
                ++length;
            }
            if (length <= 0) continue;
            partParams.add(new PartSampleNeighborParam(this.matrixId, (PartitionKey)partitions.get(partIndex), this.count, this.nodeIds, nodeIndex - length, nodeIndex));
        }
        return partParams;
    }
}

