/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor2;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import io.netty.buffer.ByteBuf;

public class PartSampleNeighborParam
extends PartitionGetParam {
    private long[] nodeIds;
    private int count;
    private int startIndex;
    private int endIndex;

    public PartSampleNeighborParam(int matrixId, PartitionKey part, int count, long[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, part);
        this.nodeIds = nodeIds;
        this.count = count;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public PartSampleNeighborParam() {
        this(0, null, 0, null, 0, 0);
    }

    public long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.endIndex - this.startIndex);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            buf.writeLong(this.nodeIds[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.count = buf.readInt();
        this.nodeIds = new long[buf.readInt()];
        for (int i = 0; i < this.nodeIds.length; ++i) {
            this.nodeIds[i] = buf.readLong();
        }
    }

    public int bufferLen() {
        return super.bufferLen() + 8 + 8 * (this.endIndex - this.startIndex);
    }
}

