/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor2;

import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;

public class PartSampleNeighborResult
extends PartitionGetResult {
    private int partId;
    private long[][] nodeIdToNeighbors;

    public PartSampleNeighborResult(int partId, long[][] nodeIdToNeighbors) {
        this.partId = partId;
        this.nodeIdToNeighbors = nodeIdToNeighbors;
    }

    public PartSampleNeighborResult() {
        this(-1, null);
    }

    public long[][] getNodeIdToNeighbors() {
        return this.nodeIdToNeighbors;
    }

    public void setNodeIdToNeighbors(long[][] nodeIdToNeighbors) {
        this.nodeIdToNeighbors = nodeIdToNeighbors;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf output) {
        output.writeInt(this.partId);
        output.writeInt(this.nodeIdToNeighbors.length);
        for (int i = 0; i < this.nodeIdToNeighbors.length; ++i) {
            if (this.nodeIdToNeighbors[i] == null) {
                output.writeInt(0);
                continue;
            }
            output.writeInt(this.nodeIdToNeighbors[i].length);
            for (long value : this.nodeIdToNeighbors[i]) {
                output.writeLong(value);
            }
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = input.readInt();
        int size = input.readInt();
        this.nodeIdToNeighbors = new long[size][];
        for (int i = 0; i < size; ++i) {
            long[] neighbors = new long[input.readInt()];
            for (int j = 0; j < neighbors.length; ++j) {
                neighbors[j] = input.readLong();
            }
            this.nodeIdToNeighbors[i] = neighbors;
        }
    }

    public int bufferLen() {
        int len = 8;
        for (int i = 0; i < this.nodeIdToNeighbors.length; ++i) {
            if (this.nodeIdToNeighbors[i] == null) {
                len += 4;
                continue;
            }
            len += 4;
            len += 8 * this.nodeIdToNeighbors[i].length;
        }
        return len;
    }
}

