/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor2;

import com.tencent.angel.graph.client.sampleneighbor2.PartSampleNeighborParam;
import com.tencent.angel.graph.client.sampleneighbor2.PartSampleNeighborResult;
import com.tencent.angel.graph.client.sampleneighbor2.SampleNeighborParam;
import com.tencent.angel.graph.client.sampleneighbor2.SampleNeighborResult;
import com.tencent.angel.ml.matrix.psf.get.base.GetFunc;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetResult;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.matrix.ServerMatrix;
import com.tencent.angel.ps.storage.partition.RowBasedPartition;
import com.tencent.angel.ps.storage.partition.ServerPartition;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import com.tencent.angel.ps.storage.vector.element.LongArrayElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;

public class SampleNeighbor
extends GetFunc {
    public SampleNeighbor(SampleNeighborParam param) {
        super((GetParam)param);
    }

    public SampleNeighbor() {
        this(null);
    }

    public PartitionGetResult partitionGet(PartitionGetParam partParam) {
        PartSampleNeighborParam param = (PartSampleNeighborParam)partParam;
        ServerMatrix matrix = this.psContext.getMatrixStorageManager().getMatrix(partParam.getMatrixId());
        ServerPartition part = matrix.getPartition(partParam.getPartKey().getPartitionId());
        ServerLongAnyRow row = (ServerLongAnyRow)((RowBasedPartition)part).getRow(0);
        long[] nodeIds = param.getNodeIds();
        long[][] neighbors = new long[nodeIds.length][];
        int count = param.getCount();
        Random r = new Random();
        for (int i = 0; i < nodeIds.length; ++i) {
            long nodeId = nodeIds[i];
            LongArrayElement element = (LongArrayElement)row.get(nodeId);
            if (element == null) {
                neighbors[i] = null;
                continue;
            }
            long[] nodeNeighbors = element.getData();
            if (nodeNeighbors == null || nodeNeighbors.length == 0) {
                neighbors[i] = null;
                continue;
            }
            if (count <= 0 || nodeNeighbors.length <= count) {
                neighbors[i] = nodeNeighbors;
                continue;
            }
            neighbors[i] = new long[count];
            int startPos = Math.abs(r.nextInt()) % nodeNeighbors.length;
            if (startPos + count <= nodeNeighbors.length) {
                System.arraycopy(nodeNeighbors, startPos, neighbors[i], 0, count);
                continue;
            }
            System.arraycopy(nodeNeighbors, startPos, neighbors[i], 0, nodeNeighbors.length - startPos);
            System.arraycopy(nodeNeighbors, 0, neighbors[i], nodeNeighbors.length - startPos, count - (nodeNeighbors.length - startPos));
        }
        return new PartSampleNeighborResult(part.getPartitionKey().getPartitionId(), neighbors);
    }

    public GetResult merge(List<PartitionGetResult> partResults) {
        Int2ObjectArrayMap partIdToResultMap = new Int2ObjectArrayMap(partResults.size());
        for (PartitionGetResult result : partResults) {
            partIdToResultMap.put(((PartSampleNeighborResult)result).getPartId(), (Object)result);
        }
        SampleNeighborParam param = (SampleNeighborParam)this.getParam();
        long[] nodeIds = param.getNodeIds();
        List<PartitionGetParam> partParams = param.getPartParams();
        Long2ObjectOpenHashMap nodeIdToNeighbors = new Long2ObjectOpenHashMap(nodeIds.length);
        for (PartitionGetParam partParam : partParams) {
            int start = ((PartSampleNeighborParam)partParam).getStartIndex();
            int end = ((PartSampleNeighborParam)partParam).getEndIndex();
            PartSampleNeighborResult partResult = (PartSampleNeighborResult)((Object)partIdToResultMap.get(partParam.getPartKey().getPartitionId()));
            long[][] results = partResult.getNodeIdToNeighbors();
            for (int i = start; i < end; ++i) {
                nodeIdToNeighbors.put(nodeIds[i], (Object)results[i - start]);
            }
        }
        return new SampleNeighborResult((Long2ObjectOpenHashMap<long[]>)nodeIdToNeighbors);
    }
}

