/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor4;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.sampleneighbor4.SampleNeighborPartParam;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SampleNeighborParam
extends GetParam {
    private final long[] keys;
    private final int numSample;
    private final List<PartitionGetParam> params;
    private final boolean sampleTypes;

    public SampleNeighborParam(int matrixId, long[] keys, int numSample, boolean sampleTypes) {
        super(matrixId);
        this.keys = keys;
        this.numSample = numSample;
        this.params = new ArrayList<PartitionGetParam>();
        this.sampleTypes = sampleTypes;
    }

    public SampleNeighborParam() {
        this(-1, null, -1, false);
    }

    public List<PartitionGetParam> getParams() {
        return this.params;
    }

    public long[] getKeys() {
        return this.keys;
    }

    public boolean getSampleTypes() {
        return this.sampleTypes;
    }

    public List<PartitionGetParam> split() {
        Arrays.sort(this.keys);
        List partitions = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        if (!RowUpdateSplitUtils.isInRange((long[])this.keys, (List)partitions)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)partitions.get(0)).getStartCol() + ", " + ((PartitionKey)partitions.get(partitions.size() - 1)).getEndCol());
        }
        int nodeIndex = 0;
        for (int partIndex = 0; nodeIndex < this.keys.length || partIndex < partitions.size(); ++partIndex) {
            int length = 0;
            long endOffset = ((PartitionKey)partitions.get(partIndex)).getEndCol();
            while (nodeIndex < this.keys.length && this.keys[nodeIndex] < endOffset) {
                ++nodeIndex;
                ++length;
            }
            if (length <= 0) continue;
            this.params.add(new SampleNeighborPartParam(this.matrixId, (PartitionKey)partitions.get(partIndex), this.numSample, this.keys, this.sampleTypes, nodeIndex - length, nodeIndex));
        }
        return this.params;
    }
}

