/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor4;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import io.netty.buffer.ByteBuf;

public class SampleNeighborPartParam
extends PartitionGetParam {
    private long[] keys;
    private int numSample;
    private int startIndex;
    private int endIndex;
    private boolean sampleTypes;

    public SampleNeighborPartParam(int matrixId, PartitionKey pkey, int numSample, long[] keys, boolean sampleTypes, int startIndex, int endIndex) {
        super(matrixId, pkey);
        this.keys = keys;
        this.numSample = numSample;
        this.sampleTypes = sampleTypes;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        assert (endIndex > startIndex);
    }

    public SampleNeighborPartParam() {
        this(0, null, 0, null, false, 0, 0);
    }

    public long[] getKeys() {
        return this.keys;
    }

    public int getNumSample() {
        return this.numSample;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean getSampleTypes() {
        return this.sampleTypes;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.numSample);
        buf.writeBoolean(this.sampleTypes);
        buf.writeInt(this.endIndex - this.startIndex);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            buf.writeLong(this.keys[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.numSample = buf.readInt();
        this.sampleTypes = buf.readBoolean();
        this.keys = new long[buf.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = buf.readLong();
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        return len += 8 + ByteBufSerdeUtils.serializedBooleanLen((boolean)this.sampleTypes) + 8 * (this.endIndex - this.startIndex);
    }
}

