/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.sampleneighbor4;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.graph.data.Node;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import io.netty.buffer.ByteBuf;
import java.util.Random;

public class SampleNeighborPartResult
extends PartitionGetResult {
    private int partId;
    private int[] indptr;
    private int[] types;
    private long[] neighbors;
    ServerLongAnyRow row;
    long[] keys;
    int numSample;
    boolean sampleTypes;

    public SampleNeighborPartResult(int partId, ServerLongAnyRow row, long[] keys, int numSample, boolean sampleTypes) {
        this.partId = partId;
        this.keys = keys;
        this.numSample = numSample;
        this.row = row;
        this.sampleTypes = sampleTypes;
    }

    public SampleNeighborPartResult() {
    }

    public int[] getIndptr() {
        return this.indptr;
    }

    public long[] getNeighbors() {
        return this.neighbors;
    }

    public int[] getTypes() {
        return this.types;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf buf) {
        Random rand = new Random(System.currentTimeMillis());
        buf.writeInt(this.partId);
        buf.writeBoolean(this.sampleTypes);
        buf.writeInt(this.keys.length);
        int writeIndex = buf.writerIndex();
        buf.writeInt(0);
        int length = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            int idx;
            int j;
            Node node = (Node)this.row.get(this.keys[i]);
            if (node == null) {
                buf.writeInt(0);
                continue;
            }
            long[] neighbor = node.getNeighbors();
            int[] types = node.getTypes();
            if (neighbor == null || neighbor.length == 0) {
                buf.writeInt(0);
                continue;
            }
            int size = this.numSample;
            if (this.numSample <= 0 || this.numSample >= neighbor.length) {
                size = neighbor.length;
            }
            length += size;
            buf.writeInt(size);
            int start = rand.nextInt(neighbor.length);
            if (this.sampleTypes) {
                for (j = 0; j < size; ++j) {
                    idx = (start + j) % neighbor.length;
                    buf.writeLong(neighbor[idx]);
                    buf.writeInt(types[idx]);
                }
                continue;
            }
            for (j = 0; j < size; ++j) {
                idx = (start + j) % neighbor.length;
                buf.writeLong(neighbor[idx]);
            }
        }
        buf.setInt(writeIndex, length);
    }

    public void deserialize(ByteBuf buf) {
        this.partId = buf.readInt();
        this.sampleTypes = buf.readBoolean();
        int keysLen = buf.readInt();
        int neighborLen = buf.readInt();
        this.indptr = new int[keysLen + 1];
        this.neighbors = new long[neighborLen];
        if (this.sampleTypes) {
            this.types = new int[neighborLen];
        }
        int idx1 = 0;
        int idx2 = 0;
        this.indptr[idx1++] = 0;
        if (!this.sampleTypes) {
            for (int i = 0; i < keysLen; ++i) {
                int size = buf.readInt();
                for (int j = 0; j < size; ++j) {
                    this.neighbors[idx2++] = buf.readLong();
                }
                this.indptr[idx1++] = idx2;
            }
        } else {
            for (int i = 0; i < keysLen; ++i) {
                int size = buf.readInt();
                for (int j = 0; j < size; ++j) {
                    this.neighbors[idx2] = buf.readLong();
                    this.types[idx2++] = buf.readInt();
                }
                this.indptr[idx1++] = idx2;
            }
        }
    }

    public int bufferLen() {
        int len = 12 + ByteBufSerdeUtils.serializedBooleanLen((boolean)this.sampleTypes);
        for (int i = 0; i < this.keys.length; ++i) {
            int j;
            Node node = (Node)this.row.get(this.keys[i]);
            if (node == null) {
                len += 4;
                continue;
            }
            long[] neighbor = node.getNeighbors();
            if (neighbor == null || neighbor.length == 0) {
                len += 4;
                continue;
            }
            int size = this.numSample;
            if (this.numSample <= 0 || this.numSample >= neighbor.length) {
                size = neighbor.length;
            }
            len += 4;
            if (this.sampleTypes) {
                for (j = 0; j < size; ++j) {
                    len += 12;
                }
                continue;
            }
            for (j = 0; j < size; ++j) {
                len += 8;
            }
        }
        return len;
    }
}

