/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.data;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.common.StreamSerdeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GraphNode
implements IElement {
    private IntFloatVector feats;
    private long[] neighbors;
    private int[] types;
    private int[] edgeTypes;
    private IntFloatVector[] edgeFeatures;
    private float[] weights;
    private float[] labels;

    public GraphNode(IntFloatVector feats, long[] neighbors, int[] types, int[] edgeTypes, IntFloatVector[] edgeFeatures, float[] weights, float[] labels) {
        this.feats = feats;
        this.neighbors = neighbors;
        this.types = types;
        this.edgeTypes = edgeTypes;
        this.edgeFeatures = edgeFeatures;
        this.weights = weights;
        this.labels = labels;
    }

    public GraphNode(IntFloatVector feats, long[] neighbors) {
        this(feats, neighbors, null, null, null, null, null);
    }

    public GraphNode() {
        this(null, null, null, null, null, null, null);
    }

    public IntFloatVector getFeats() {
        return this.feats;
    }

    public void setFeats(IntFloatVector feats) {
        this.feats = feats;
    }

    public long[] getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(long[] neighbors) {
        this.neighbors = neighbors;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public int[] getEdgeTypes() {
        return this.edgeTypes;
    }

    public void setEdgeTypes(int[] edgeTypes) {
        this.edgeTypes = edgeTypes;
    }

    public IntFloatVector[] getEdgeFeatures() {
        return this.edgeFeatures;
    }

    public void setEdgeFeatures(IntFloatVector[] edgeFeatures) {
        this.edgeFeatures = edgeFeatures;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setWeights(float[] weights) {
        this.weights = weights;
    }

    public float[] getLabels() {
        return this.labels;
    }

    public void setLabels(float[] labels) {
        this.labels = labels;
    }

    public GraphNode deepClone() {
        IntFloatVector cloneFeats = null;
        if (this.feats != null) {
            cloneFeats = this.feats.clone();
        }
        long[] cloneNeighbors = null;
        if (this.neighbors != null) {
            cloneNeighbors = new long[this.neighbors.length];
            System.arraycopy(this.neighbors, 0, cloneNeighbors, 0, this.neighbors.length);
        }
        int[] cloneTypes = null;
        if (this.types != null) {
            cloneTypes = new int[this.types.length];
            System.arraycopy(this.types, 0, cloneTypes, 0, this.types.length);
        }
        int[] cloneEdgeTypes = null;
        if (this.edgeTypes != null) {
            cloneEdgeTypes = new int[this.edgeTypes.length];
            System.arraycopy(this.edgeTypes, 0, cloneEdgeTypes, 0, this.edgeTypes.length);
        }
        IntFloatVector[] cloneEdgeFeatures = null;
        if (this.edgeFeatures != null) {
            cloneEdgeFeatures = new IntFloatVector[this.edgeFeatures.length];
            System.arraycopy(this.edgeFeatures, 0, cloneEdgeFeatures, 0, this.edgeFeatures.length);
        }
        float[] cloneWeights = null;
        if (this.weights != null) {
            cloneWeights = new float[this.weights.length];
            System.arraycopy(this.weights, 0, cloneWeights, 0, this.weights.length);
        }
        float[] cloneLables = null;
        if (this.labels != null) {
            cloneLables = new float[this.labels.length];
            System.arraycopy(this.labels, 0, cloneLables, 0, this.labels.length);
        }
        return new GraphNode(cloneFeats, cloneNeighbors, cloneTypes, cloneEdgeTypes, cloneEdgeFeatures, cloneWeights, cloneLables);
    }

    public void serialize(ByteBuf output) {
        if (this.feats != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeVector((ByteBuf)output, (Vector)this.feats);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.neighbors != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])this.neighbors);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.types != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])this.types);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.edgeTypes != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeInts((ByteBuf)output, (int[])this.edgeTypes);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.edgeFeatures != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)this.edgeFeatures.length);
            for (IntFloatVector edgeFeature : this.edgeFeatures) {
                ByteBufSerdeUtils.serializeVector((ByteBuf)output, (Vector)edgeFeature);
            }
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.weights != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeFloats((ByteBuf)output, (float[])this.weights);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
        if (this.labels != null) {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)1);
            ByteBufSerdeUtils.serializeFloats((ByteBuf)output, (float[])this.labels);
        } else {
            ByteBufSerdeUtils.serializeInt((ByteBuf)output, (int)0);
        }
    }

    public void deserialize(ByteBuf input) {
        int labelsFlag;
        int weightsFlag;
        int edgeFeaturesFlag;
        int edgeTypesFlag;
        int typesFlag;
        int neighborsFlag;
        int featsFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
        if (featsFlag > 0) {
            this.feats = (IntFloatVector)ByteBufSerdeUtils.deserializeVector((ByteBuf)input);
        }
        if ((neighborsFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.neighbors = ByteBufSerdeUtils.deserializeLongs((ByteBuf)input);
        }
        if ((typesFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.types = ByteBufSerdeUtils.deserializeInts((ByteBuf)input);
        }
        if ((edgeTypesFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.edgeTypes = ByteBufSerdeUtils.deserializeInts((ByteBuf)input);
        }
        if ((edgeFeaturesFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            int len = ByteBufSerdeUtils.deserializeInt((ByteBuf)input);
            this.edgeFeatures = new IntFloatVector[len];
            for (int i = 0; i < len; ++i) {
                this.edgeFeatures[i] = (IntFloatVector)ByteBufSerdeUtils.deserializeVector((ByteBuf)input);
            }
        }
        if ((weightsFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.weights = ByteBufSerdeUtils.deserializeFloats((ByteBuf)input);
        }
        if ((labelsFlag = ByteBufSerdeUtils.deserializeInt((ByteBuf)input)) > 0) {
            this.weights = ByteBufSerdeUtils.deserializeFloats((ByteBuf)input);
        }
    }

    public int bufferLen() {
        int len = 28;
        if (this.feats != null) {
            len += ByteBufSerdeUtils.serializedVectorLen((Vector)this.feats);
        }
        if (this.neighbors != null) {
            len += ByteBufSerdeUtils.serializedLongsLen((long[])this.neighbors);
        }
        if (this.types != null) {
            len += ByteBufSerdeUtils.serializedIntsLen((int[])this.types);
        }
        if (this.edgeTypes != null) {
            len += ByteBufSerdeUtils.serializedIntsLen((int[])this.edgeTypes);
        }
        if (this.edgeFeatures != null) {
            len += 4;
            for (IntFloatVector edgeFeature : this.edgeFeatures) {
                len += ByteBufSerdeUtils.serializedVectorLen((Vector)edgeFeature);
            }
        }
        if (this.weights != null) {
            len += ByteBufSerdeUtils.serializedFloatsLen((float[])this.weights);
        }
        if (this.labels != null) {
            len += ByteBufSerdeUtils.serializedFloatsLen((float[])this.labels);
        }
        return len;
    }

    public void serialize(DataOutputStream output) throws IOException {
        if (this.feats != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeVector((DataOutputStream)output, (Vector)this.feats);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.neighbors != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeLongs((DataOutputStream)output, (long[])this.neighbors);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.types != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeInts((DataOutputStream)output, (int[])this.types);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.edgeTypes != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeInts((DataOutputStream)output, (int[])this.edgeTypes);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.edgeFeatures != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)this.edgeFeatures.length);
            for (IntFloatVector edgeFeature : this.edgeFeatures) {
                StreamSerdeUtils.serializeVector((DataOutputStream)output, (Vector)edgeFeature);
            }
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.weights != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeFloats((DataOutputStream)output, (float[])this.weights);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
        if (this.labels != null) {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)1);
            StreamSerdeUtils.serializeFloats((DataOutputStream)output, (float[])this.labels);
        } else {
            StreamSerdeUtils.serializeInt((DataOutputStream)output, (int)0);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        int labelsFlag;
        int weightsFlag;
        int edgeFeaturesFlag;
        int edgeTypesFlag;
        int typesFlag;
        int neighborsFlag;
        int featsFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input);
        if (featsFlag > 0) {
            this.feats = (IntFloatVector)StreamSerdeUtils.deserializeVector((DataInputStream)input);
        }
        if ((neighborsFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            this.neighbors = StreamSerdeUtils.deserializeLongs((DataInputStream)input);
        }
        if ((typesFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            this.types = StreamSerdeUtils.deserializeInts((DataInputStream)input);
        }
        if ((edgeTypesFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            this.edgeTypes = StreamSerdeUtils.deserializeInts((DataInputStream)input);
        }
        if ((edgeFeaturesFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            int len = StreamSerdeUtils.deserializeInt((DataInputStream)input);
            this.edgeFeatures = new IntFloatVector[len];
            for (int i = 0; i < len; ++i) {
                this.edgeFeatures[i] = (IntFloatVector)StreamSerdeUtils.deserializeVector((DataInputStream)input);
            }
        }
        if ((weightsFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            this.weights = StreamSerdeUtils.deserializeFloats((DataInputStream)input);
        }
        if ((labelsFlag = StreamSerdeUtils.deserializeInt((DataInputStream)input)) > 0) {
            this.weights = StreamSerdeUtils.deserializeFloats((DataInputStream)input);
        }
    }

    public int dataLen() {
        return this.bufferLen();
    }
}

