/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.data;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.common.StreamSerdeUtils;
import com.tencent.angel.graph.data.LongNeighbor;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LongEdgeFeats
extends LongNeighbor {
    private IntFloatVector[] feats;

    public LongEdgeFeats(long[] nodeIds, IntFloatVector[] feats) {
        super(nodeIds);
        this.feats = feats;
    }

    public LongEdgeFeats() {
        super(null);
    }

    public IntFloatVector[] getFeats() {
        return this.feats;
    }

    @Override
    public void serialize(ByteBuf output) {
        super.serialize(output);
        ByteBufSerdeUtils.serializeIntFloatVectors((ByteBuf)output, (IntFloatVector[])this.feats);
    }

    @Override
    public void deserialize(ByteBuf input) {
        super.deserialize(input);
        this.feats = ByteBufSerdeUtils.deserializeIntFloatVectors((ByteBuf)input);
    }

    @Override
    public int bufferLen() {
        return super.bufferLen() + ByteBufSerdeUtils.serializedIntFloatVectorsLen((IntFloatVector[])this.feats);
    }

    @Override
    public void serialize(DataOutputStream output) throws IOException {
        super.serialize(output);
        StreamSerdeUtils.serializeIntFloatVectors((DataOutputStream)output, (IntFloatVector[])this.feats);
    }

    @Override
    public void deserialize(DataInputStream input) throws IOException {
        super.deserialize(input);
        this.feats = StreamSerdeUtils.deserializeIntFloatVectors((DataInputStream)input);
    }

    @Override
    public int dataLen() {
        return this.bufferLen();
    }
}

