/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.data;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LongNeighbor
implements IElement {
    private long[] nodeIds;

    public LongNeighbor(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public LongNeighbor() {
        this(null);
    }

    public Object deepClone() {
        long[] newNodeIds = new long[this.nodeIds.length];
        System.arraycopy(this.nodeIds, 0, newNodeIds, 0, this.nodeIds.length);
        return new LongNeighbor(newNodeIds);
    }

    public void serialize(ByteBuf output) {
        ByteBufSerdeUtils.serializeLongs((ByteBuf)output, (long[])this.nodeIds);
    }

    public void deserialize(ByteBuf input) {
        this.nodeIds = ByteBufSerdeUtils.deserializeLongs((ByteBuf)input);
    }

    public int bufferLen() {
        return ByteBufSerdeUtils.serializedLongsLen((long[])this.nodeIds);
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeInt(this.nodeIds.length);
        for (int i = 0; i < this.nodeIds.length; ++i) {
            output.writeLong(this.nodeIds[i]);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.nodeIds = new long[input.readInt()];
        for (int i = 0; i < this.nodeIds.length; ++i) {
            this.nodeIds[i] = input.readLong();
        }
    }

    public int dataLen() {
        return this.bufferLen();
    }

    public long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }
}

