/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.data;

import com.tencent.angel.graph.data.NodeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ps.storage.vector.element.IElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Node
implements IElement {
    private IntFloatVector feats;
    private long[] neighbors;
    private IntFloatVector[] edgeFeatures;
    private int[] types;
    private int[] edgeTypes;
    private float[] labels;

    public Node(IntFloatVector feats, long[] neighbors) {
        this(feats, neighbors, null);
    }

    public Node(IntFloatVector feats, long[] neighbors, int[] types) {
        this.feats = feats;
        this.neighbors = neighbors;
        this.types = types;
    }

    public Node(IntFloatVector feats, long[] neighbors, int[] types, float[] labels) {
        this(feats, neighbors, types);
        this.labels = labels;
    }

    public Node(IntFloatVector feats, long[] neighbors, IntFloatVector[] edgeFeatures, int[] types) {
        this(feats, neighbors, types);
        this.edgeFeatures = edgeFeatures;
    }

    public Node() {
        this(null, null, null);
    }

    public IntFloatVector getFeats() {
        return this.feats;
    }

    public void setFeats(IntFloatVector feats) {
        this.feats = feats;
    }

    public long[] getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(long[] neighbors) {
        this.neighbors = neighbors;
    }

    public IntFloatVector[] getEdgeFeatures() {
        return this.edgeFeatures;
    }

    public void setEdgeFeatures(IntFloatVector[] edgeFeats) {
        this.edgeFeatures = edgeFeats;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public int[] getEdgeTypes() {
        return this.edgeTypes;
    }

    public void setEdgeTypes(int[] edgeTypes) {
        this.edgeTypes = edgeTypes;
    }

    public float[] getLabels() {
        return this.labels;
    }

    public void setLabels(float[] labels) {
        this.labels = labels;
    }

    public Node deepClone() {
        if (this.feats != null && this.neighbors != null) {
            IntFloatVector cloneFeats = this.feats.clone();
            long[] cloneNeighbors = new long[this.neighbors.length];
            System.arraycopy(this.neighbors, 0, cloneNeighbors, 0, this.neighbors.length);
            if (this.types == null) {
                return new Node(cloneFeats, cloneNeighbors);
            }
            int[] cloneTypes = new int[this.types.length];
            System.arraycopy(this.types, 0, cloneTypes, 0, this.types.length);
            return new Node(cloneFeats, cloneNeighbors, cloneTypes);
        }
        return new Node();
    }

    public void serialize(ByteBuf output) {
        if (this.feats != null && this.neighbors != null) {
            int i;
            output.writeInt(1);
            NodeUtils.serialize(this.feats, output);
            output.writeInt(this.neighbors.length);
            for (i = 0; i < this.neighbors.length; ++i) {
                output.writeLong(this.neighbors[i]);
            }
            if (this.types != null) {
                output.writeInt(this.types.length);
                for (i = 0; i < this.types.length; ++i) {
                    output.writeInt(this.types[i]);
                }
            } else {
                output.writeInt(0);
            }
        } else {
            output.writeInt(0);
        }
    }

    public void deserialize(ByteBuf input) {
        int derFlag = input.readInt();
        if (0 != derFlag) {
            int i;
            this.feats = NodeUtils.deserialize(input);
            int len = input.readInt();
            this.neighbors = new long[len];
            for (i = 0; i < len; ++i) {
                this.neighbors[i] = input.readLong();
            }
            len = input.readInt();
            if (0 != len) {
                this.types = new int[len];
                for (i = 0; i < len; ++i) {
                    this.types[i] = input.readInt();
                }
            }
        }
    }

    public int bufferLen() {
        int len = 4;
        if (this.feats != null && this.neighbors != null) {
            len = NodeUtils.dataLen(this.feats);
            len += 4 + 8 * this.neighbors.length;
            len = this.types != null ? (len += 4 + 4 * this.types.length) : (len += 4);
        }
        return len;
    }

    public void serialize(DataOutputStream output) throws IOException {
        if (this.feats != null && this.neighbors != null) {
            int i;
            output.writeInt(1);
            NodeUtils.serialize(this.feats, output);
            output.writeInt(this.neighbors.length);
            for (i = 0; i < this.neighbors.length; ++i) {
                output.writeLong(this.neighbors[i]);
            }
            if (this.types != null) {
                output.writeInt(this.types.length);
                for (i = 0; i < this.types.length; ++i) {
                    output.writeInt(this.types[i]);
                }
            } else {
                output.writeInt(0);
            }
        } else {
            output.writeInt(0);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        int derFlag = input.readInt();
        if (0 != derFlag) {
            int i;
            this.feats = NodeUtils.deserialize(input);
            int len = input.readInt();
            this.neighbors = new long[len];
            for (i = 0; i < len; ++i) {
                this.neighbors[i] = input.readLong();
            }
            len = input.readInt();
            if (0 != len) {
                this.types = new int[len];
                for (i = 0; i < len; ++i) {
                    this.types[i] = input.readInt();
                }
            }
        }
    }

    public int dataLen() {
        return this.bufferLen();
    }
}

