/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo;

import com.tencent.angel.ml.GBDT.algo.GBDTController;
import com.tencent.angel.ml.GBDT.algo.RegTree.RegTNodeStat;
import com.tencent.angel.ml.GBDT.algo.tree.SplitEntry;
import com.tencent.angel.ml.GBDT.algo.tree.TNode;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.IntIntVector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfterSplitThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AfterSplitThread.class);
    private final GBDTController controller;
    private final int nid;
    private final IntIntVector splitFeatureVec;
    private final IntDoubleVector splitValueVec;
    private final IntDoubleVector splitGainVec;
    private final IntDoubleVector nodeGradStatsVec;

    public AfterSplitThread(GBDTController controller, int nid, IntIntVector splitFeatureVec, IntDoubleVector splitValueVec, IntDoubleVector splitGainVec, IntDoubleVector nodeGradStatsVec) {
        this.controller = controller;
        this.nid = nid;
        this.splitFeatureVec = splitFeatureVec;
        this.splitValueVec = splitValueVec;
        this.splitGainVec = splitGainVec;
        this.nodeGradStatsVec = nodeGradStatsVec;
    }

    @Override
    public void run() {
        int splitFeature = this.splitFeatureVec.get(this.nid);
        float splitValue = (float)this.splitValueVec.get(this.nid);
        float splitGain = (float)this.splitGainVec.get(this.nid);
        float nodeSumGrad = (float)this.nodeGradStatsVec.get(this.nid);
        float nodeSumHess = (float)this.nodeGradStatsVec.get(this.nid + this.controller.maxNodeNum);
        LOG.info((Object)String.format("Active node[%d]: split feature[%d] value[%f], lossChg[%f], sumGrad[%f], sumHess[%f]", this.nid, splitFeature, Float.valueOf(splitValue), Float.valueOf(splitGain), Float.valueOf(nodeSumGrad), Float.valueOf(nodeSumHess)));
        if (splitFeature != -1) {
            this.controller.forest[this.controller.currentTree].nodes.get(this.nid).setLeftChild(2 * this.nid + 1);
            this.controller.forest[this.controller.currentTree].nodes.get(this.nid).setRightChild(2 * this.nid + 2);
            SplitEntry splitEntry = new SplitEntry(splitFeature, splitValue, splitGain);
            this.controller.forest[this.controller.currentTree].stats.get(this.nid).setSplitEntry(splitEntry);
            this.controller.forest[this.controller.currentTree].stats.get((int)this.nid).lossChg = splitGain;
            this.controller.forest[this.controller.currentTree].stats.get(this.nid).setStats(nodeSumGrad, nodeSumHess);
            TNode leftChild = new TNode(2 * this.nid + 1, this.nid, -1, -1);
            TNode rightChild = new TNode(2 * this.nid + 2, this.nid, -1, -1);
            this.controller.forest[this.controller.currentTree].nodes.set(2 * this.nid + 1, leftChild);
            this.controller.forest[this.controller.currentTree].nodes.set(2 * this.nid + 2, rightChild);
            LOG.debug((Object)String.format("Add children nodes: %d and %d", 2 * this.nid + 1, 2 * this.nid + 2));
            RegTNodeStat leftChildStat = new RegTNodeStat(this.controller.param);
            RegTNodeStat rightChildStat = new RegTNodeStat(this.controller.param);
            float leftChildSumGrad = (float)this.nodeGradStatsVec.get(2 * this.nid + 1);
            float rightChildSumGrad = (float)this.nodeGradStatsVec.get(2 * this.nid + 2);
            float leftChildSumHess = (float)this.nodeGradStatsVec.get(2 * this.nid + 1 + this.controller.maxNodeNum);
            float rightChildSumHess = (float)this.nodeGradStatsVec.get(2 * this.nid + 2 + this.controller.maxNodeNum);
            leftChildStat.setStats(leftChildSumGrad, leftChildSumHess);
            rightChildStat.setStats(rightChildSumGrad, rightChildSumHess);
            this.controller.forest[this.controller.currentTree].stats.set(2 * this.nid + 1, leftChildStat);
            this.controller.forest[this.controller.currentTree].stats.set(2 * this.nid + 2, rightChildStat);
            this.controller.updateTrainInsPos(this.nid, splitFeature, splitValue);
            if (this.controller.currentDepth < this.controller.param.maxDepth - 1) {
                LOG.debug((Object)String.format("Add children nodes of node[%d]:[%d][%d] to active nodes", this.nid, 2 * this.nid + 1, 2 * this.nid + 2));
                this.controller.addActiveNode(2 * this.nid + 1);
                this.controller.addActiveNode(2 * this.nid + 2);
            } else {
                LOG.debug((Object)String.format("Set children nodes of node[%d]:[%d][%d] to leaf nodes", this.nid, 2 * this.nid + 1, 2 * this.nid + 2));
                this.controller.setNodeToLeaf(2 * this.nid + 1, leftChildStat.baseWeight);
                this.controller.setNodeToLeaf(2 * this.nid + 2, rightChildStat.baseWeight);
            }
        } else {
            this.controller.setNodeToLeaf(this.nid, this.controller.param.calcWeight(nodeSumGrad, nodeSumHess));
            LOG.debug((Object)String.format("Set node %d to leaf", this.nid));
        }
        this.controller.resetActiveTNodes(this.nid);
    }
}

