/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo;

import com.tencent.angel.ml.core.utils.Maths;
import com.tencent.angel.utils.Sort;

public class FeatureMeta {
    public int numFeature;
    public float[] minFeatures;
    public float[] maxFeatures;

    public int type(int fid) {
        assert (fid < this.minFeatures.length);
        float min = this.minFeatures[fid];
        float max = this.maxFeatures[fid];
        if (min == Float.MAX_VALUE) {
            return 0;
        }
        if (min == max) {
            return 1;
        }
        return 2;
    }

    public float maxValue(int fid) {
        return this.maxFeatures[fid];
    }

    public float minValue(int fid) {
        return this.minFeatures[fid];
    }

    public int[] sampleCol(float p) {
        int size = (int)p * this.numFeature;
        int[] findex = new int[this.numFeature];
        for (int fid = 0; fid < this.numFeature; ++fid) {
            findex[fid] = fid;
        }
        Maths.shuffle(findex);
        int[] rec = new int[size];
        System.arraycopy(findex, 0, rec, 0, rec.length);
        Sort.quickSort((int[])rec, (int[])new int[rec.length], (int)0, (int)(rec.length - 1));
        return rec;
    }

    public FeatureMeta(int numFeature, float[] minFeatures, float[] maxFeatures) {
        this.numFeature = numFeature;
        this.minFeatures = minFeatures;
        this.maxFeatures = maxFeatures;
    }
}

