/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo;

import com.tencent.angel.ml.GBDT.algo.GBDTController;
import com.tencent.angel.ml.GBDT.algo.RegTree.GradHistHelper;
import com.tencent.angel.ml.core.conf.MLConf;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateFunc;
import com.tencent.angel.ml.model.PSModel;
import com.tencent.angel.ml.psf.compress.QuantifyDoubleFunc;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GradHistThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(GradHistThread.class);
    private final GBDTController controller;
    private final int nid;
    private final PSModel model;
    private int insStart;
    private int insEnd;

    public GradHistThread(GBDTController controller, int nid, PSModel model, int start, int end) {
        this.controller = controller;
        this.nid = nid;
        this.model = model;
        this.insStart = start;
        this.insEnd = end;
    }

    @Override
    public void run() {
        LOG.debug((Object)String.format("Run active node[%d]", this.nid));
        String histParaName = this.controller.param.gradHistNamePrefix + this.nid;
        GradHistHelper histMaker = new GradHistHelper(this.controller, this.nid);
        IntDoubleVector histogram = histMaker.buildHistogram(this.insStart, this.insEnd);
        int bytesPerItem = this.controller.taskContext.getConf().getInt(MLConf.ANGEL_COMPRESS_BYTES(), MLConf.DEFAULT_ANGEL_COMPRESS_BYTES());
        if (bytesPerItem < 1 || bytesPerItem > 8) {
            LOG.info((Object)("Invalid compress configuration: " + bytesPerItem + ", it should be [1,8]."));
            bytesPerItem = MLConf.DEFAULT_ANGEL_COMPRESS_BYTES();
        }
        try {
            if (bytesPerItem == 8) {
                this.model.increment(0, (Vector)histogram);
            } else {
                QuantifyDoubleFunc func = new QuantifyDoubleFunc(this.model.getMatrixId(), 0, histogram, bytesPerItem * 8);
                this.model.update((UpdateFunc)func);
            }
        }
        catch (Exception e) {
            LOG.error((Object)(histParaName + " increment failed, "), (Throwable)e);
        }
        this.controller.activeNodeStat[this.nid].decrementAndGet();
        LOG.debug((Object)String.format("Active node[%d] finish", this.nid));
    }
}

