/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo;

import com.tencent.angel.ml.GBDT.algo.GBDTController;
import com.tencent.angel.ml.GBDT.algo.RegTree.GradHistHelper;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.Vector;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistCalThread
implements Callable<Boolean> {
    private static final Log LOG = LogFactory.getLog(HistCalThread.class);
    private GBDTController controller;
    private int nid;
    private int start;
    private int end;

    public HistCalThread(GBDTController controller, int nid, int start, int end) {
        this.controller = controller;
        this.nid = nid;
        this.start = start;
        this.end = end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        GradHistHelper histMaker = new GradHistHelper(this.controller, this.nid);
        IntDoubleVector localHist = histMaker.buildHistogram(this.start, this.end);
        LOG.debug((Object)String.format("Batch histogram[%d]: %s", this.nid, Arrays.toString(localHist.get(new int[]{0, 1, 2, 3, 4, 5}))));
        HistCalThread histCalThread = this;
        synchronized (histCalThread) {
            this.controller.histCache[this.nid].iadd((Vector)localHist);
            LOG.debug((Object)String.format("Calculated histogram[%d]: %s", this.nid, Arrays.toString(this.controller.histCache[this.nid].get(new int[]{0, 1, 2, 3, 4, 5}))));
        }
        return true;
    }
}

