/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo.RegTree;

import com.tencent.angel.ml.GBDT.algo.FeatureMeta;
import com.tencent.angel.ml.GBDT.param.RegTParam;
import com.tencent.angel.ml.core.utils.Maths;
import com.tencent.angel.ml.feature.LabeledData;
import com.tencent.angel.ml.math2.VFactory;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.worker.storage.DataBlock;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegTDataStore {
    private static final Log LOG = LogFactory.getLog(RegTDataStore.class);
    public RegTParam param;
    public FeatureMeta featureMeta;
    public int numRow;
    public int numCol;
    public int numNonzero;
    public static final int kVersion = 1;
    public IntFloatVector[] instances;
    public float[] labels;
    public float[] preds;
    public float[] weights;
    public float[] baseWeights;

    public RegTDataStore(RegTParam param) {
        this.param = param;
    }

    public void init(DataBlock<LabeledData> dataSet) throws IOException {
        this.numRow = dataSet.size();
        this.numCol = this.param.numFeature;
        this.numNonzero = this.param.numNonzero;
        this.instances = new IntFloatVector[this.numRow];
        this.labels = new float[this.numRow];
        this.preds = new float[this.numRow];
        this.weights = new float[this.numRow];
        this.baseWeights = new float[this.numRow];
        double[] minFeatures = new double[this.numCol];
        double[] maxFeatures = new double[this.numCol];
        Arrays.setAll(minFeatures, i -> 0.0);
        Arrays.setAll(maxFeatures, i -> 3.4028234663852886E38);
        dataSet.resetReadIndex();
        IntFloatVector x = null;
        for (int idx = 0; idx < dataSet.size(); ++idx) {
            LabeledData data = (LabeledData)dataSet.read();
            if (data.getX() instanceof IntFloatVector) {
                x = (IntFloatVector)data.getX();
            } else if (data.getX() instanceof IntDoubleVector) {
                x = VFactory.sparseFloatVector((int)((int)data.getX().dim()), (int[])((IntDoubleVector)data.getX()).getStorage().getIndices(), (float[])Maths.double2Float(((IntDoubleVector)data.getX()).getStorage().getValues()));
            }
            double y = data.getY();
            if (y != 1.0) {
                y = 0.0;
            }
            int[] indices = x.getStorage().getIndices();
            float[] values = x.getStorage().getValues();
            for (int i2 = 0; i2 < indices.length; ++i2) {
                double fvalue = values[i2];
                int fid = indices[i2];
                if (fvalue > maxFeatures[fid]) {
                    maxFeatures[fid] = fvalue;
                }
                if (!(fvalue < minFeatures[fid])) continue;
                minFeatures[fid] = fvalue;
            }
            this.instances[idx] = x;
            this.labels[idx] = (float)y;
            this.preds[idx] = 0.0f;
            this.weights[idx] = 1.0f;
            this.baseWeights[idx] = 1.0f;
        }
        this.featureMeta = new FeatureMeta(this.numCol, Maths.double2Float(minFeatures), Maths.double2Float(maxFeatures));
    }

    public void setFeatureMeta(FeatureMeta featureMeta) {
        this.featureMeta = featureMeta;
    }

    public float getWeight(int i) {
        return this.weights.length != 0 ? this.weights[i] : 1.0f;
    }

    public float getLabel(int i) {
        return this.labels.length != 0 ? this.labels[i] : 0.0f;
    }

    public float getBaseWeight(int i) {
        return this.baseWeights.length != 0 ? this.baseWeights[i] : 0.0f;
    }

    public void Clear() {
    }

    public void setNumRow(int numRow) {
        this.numRow = numRow;
    }

    public void setNumCol(int numCol) {
        this.numCol = numCol;
    }

    public void setNumNonzero(int numNonzero) {
        this.numNonzero = numNonzero;
    }

    public void setInstances(IntFloatVector[] instances) {
        this.instances = instances;
    }

    public void setLabels(float[] labels) {
        this.labels = labels;
    }

    public void setLables(int i, float label) {
        this.labels[i] = label;
    }

    public void setPreds(float[] preds) {
        this.preds = preds;
    }

    public void setWeights(float[] weights) {
        this.weights = weights;
    }

    public void setWeight(int i, float weight) {
        this.weights[i] = weight;
    }

    public void setBaseWeights(float[] baseWeights) {
        this.baseWeights = baseWeights;
    }

    public void setBaseWeight(int i, float baseWeight) {
        this.baseWeights[i] = baseWeight;
    }
}

