/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo.RegTree;

import com.tencent.angel.ml.GBDT.algo.RegTree.GradPair;
import com.tencent.angel.ml.GBDT.algo.RegTree.GradStats;
import com.tencent.angel.ml.GBDT.algo.tree.SplitEntry;
import com.tencent.angel.ml.GBDT.param.RegTParam;
import java.util.List;

public class RegTNodeStat {
    public RegTParam param;
    public float lossChg;
    public float sumGrad;
    public float sumHess;
    public float baseWeight;
    public SplitEntry splitEntry;

    public RegTNodeStat() {
    }

    public RegTNodeStat(RegTParam param) {
        this.param = param;
        this.lossChg = 0.0f;
        this.sumGrad = 0.0f;
        this.sumHess = 0.0f;
        this.baseWeight = 0.0f;
        this.splitEntry = new SplitEntry();
    }

    public RegTNodeStat(RegTParam param, List<GradPair> gradPairs) {
        new RegTNodeStat(param);
        for (GradPair pair : gradPairs) {
            this.sumGrad += pair.getGrad();
            this.sumHess += pair.getHess();
        }
        this.baseWeight = param.calcWeight(this.sumGrad, this.sumHess);
        this.splitEntry = new SplitEntry();
    }

    public void setStats(GradStats gradStats) {
        this.sumGrad = gradStats.sumGrad;
        this.sumHess = gradStats.sumHess;
        this.baseWeight = gradStats.calcWeight(this.param);
    }

    public void setStats(float sumGrad, float sumHess) {
        this.sumGrad = sumGrad;
        this.sumHess = sumHess;
        this.baseWeight = this.param.calcWeight(sumGrad, sumHess);
    }

    public void setLossChg(float lossChg) {
        this.lossChg = lossChg;
    }

    public void setSplitEntry(SplitEntry splitEntry) {
        this.splitEntry = splitEntry;
    }
}

