/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo.sketch;

import com.tencent.angel.common.Serialize;
import com.tencent.angel.ml.GBDT.algo.sketch.QuantileSketchException;
import com.tencent.angel.ml.GBDT.algo.sketch.SketchUtils;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class HeapQuantileSketch
implements Serialize {
    private int k;
    public static final int DEFAULT_K = 128;
    protected long n;
    private long estimateN;
    private float minValue;
    private float maxValue;
    private float[] combinedBuffer;
    private int combinedBufferCapacity;
    private int baseBufferCount;
    private long bitPattern;
    static final int MIN_BASE_BUF_SIZE = 4;
    private float[] samplesArr;
    private long[] weightsArr;

    public HeapQuantileSketch(int k, long maxN) {
        SketchUtils.checkK(k);
        this.k = k;
        this.estimateN = maxN > 0L ? maxN : -1L;
        this.reset();
    }

    public HeapQuantileSketch() {
        this(128, -1L);
    }

    public HeapQuantileSketch(int k) {
        this(k, -1L);
    }

    public HeapQuantileSketch(long maxN) {
        this(128, maxN);
    }

    public HeapQuantileSketch(ByteBuf buf) {
        this.deserialize(buf);
    }

    public HeapQuantileSketch(ByteBuffer buf) {
        this.deserialize(buf);
    }

    public void reset() {
        this.n = 0L;
        this.combinedBufferCapacity = this.estimateN < 0L ? Math.min(4, this.k * 2) : (this.estimateN < (long)(this.k * 2) ? this.k * 4 : SketchUtils.needBufferCapacity(this.k, this.estimateN));
        this.combinedBuffer = new float[this.combinedBufferCapacity];
        this.baseBufferCount = 0;
        this.bitPattern = 0L;
        this.minValue = Float.MAX_VALUE;
        this.maxValue = Float.MIN_VALUE;
        this.samplesArr = null;
        this.weightsArr = null;
    }

    public void update(float value) {
        if (Float.isNaN(value)) {
            throw new QuantileSketchException("Encounter NaN value");
        }
        this.maxValue = Math.max(this.maxValue, value);
        this.minValue = Math.min(this.minValue, value);
        if (this.baseBufferCount + 1 > this.combinedBufferCapacity) {
            this.ensureBaseBuffer();
        }
        this.combinedBuffer[this.baseBufferCount++] = value;
        ++this.n;
        if (this.baseBufferCount == this.k * 2) {
            this.fullBaseBufferPropagation();
        }
    }

    private void ensureBaseBuffer() {
        int newSize;
        float[] baseBuffer = this.combinedBuffer;
        int oldSize = this.combinedBufferCapacity;
        if (oldSize >= this.k * 2) {
            throw new QuantileSketchException("Buffer over size");
        }
        this.combinedBufferCapacity = newSize = Math.max(Math.min(this.k * 2, oldSize * 2), 1);
        this.combinedBuffer = Arrays.copyOf(baseBuffer, newSize);
    }

    private void ensureLevels(long newN) {
        int numLevels = 1 + (63 - Long.numberOfLeadingZeros(newN / (long)(this.k * 2)));
        int spaceNeeded = this.k * (numLevels + 2);
        if (spaceNeeded <= this.combinedBufferCapacity) {
            return;
        }
        float[] baseBuffer = this.combinedBuffer;
        this.combinedBuffer = Arrays.copyOf(baseBuffer, spaceNeeded);
        this.combinedBufferCapacity = spaceNeeded;
    }

    private void fullBaseBufferPropagation() {
        this.ensureLevels(this.n);
        float[] baseBuffer = this.combinedBuffer;
        Arrays.sort(baseBuffer, 0, this.baseBufferCount);
        this.inPlacePropagationUpdate(0, baseBuffer, 0);
        this.baseBufferCount = 0;
        SketchUtils.checkBitPattern(this.bitPattern, this.n, this.k);
    }

    private void inPlacePropagationUpdate(int beginLevel, float[] buf, int bufBeginPos) {
        float[] levelsArr = this.combinedBuffer;
        int endLevel = beginLevel;
        long tmp = this.bitPattern >>> beginLevel;
        while ((tmp & 1L) != 0L) {
            tmp >>>= 1;
            ++endLevel;
        }
        SketchUtils.compactBuffer(buf, bufBeginPos, levelsArr, (endLevel + 2) * this.k, this.k);
        SketchUtils.levelwisePropagation(this.bitPattern, this.k, beginLevel, endLevel, buf, bufBeginPos, levelsArr);
        this.bitPattern += 1L << beginLevel;
    }

    public void makeSummary() {
        int baseBufferItems = (int)(this.n % (long)(this.k * 2));
        SketchUtils.checkBitPattern(this.bitPattern, this.n, this.k);
        int validLevels = Long.bitCount(this.bitPattern);
        int numSamples = baseBufferItems + validLevels * this.k;
        this.samplesArr = new float[numSamples];
        this.weightsArr = new long[numSamples + 1];
        this.copyBuf2Arr(numSamples);
        SketchUtils.blockyMergeSort(this.samplesArr, this.weightsArr, numSamples, this.k);
        long cnt = 0L;
        for (int i = 0; i <= numSamples; ++i) {
            long newCnt = cnt + this.weightsArr[i];
            this.weightsArr[i] = cnt;
            cnt = newCnt;
        }
    }

    private void copyBuf2Arr(int numSamples) {
        long weight = 1L;
        int cur = 0;
        int level = 0;
        for (long bp = this.bitPattern; bp != 0L; bp >>>= 1) {
            weight *= 2L;
            if ((bp & 1L) != 0L) {
                int offset = this.k * (level + 2);
                for (int i = 0; i < this.k; ++i) {
                    this.samplesArr[cur] = this.combinedBuffer[i + offset];
                    this.weightsArr[cur] = weight;
                    ++cur;
                }
            }
            ++level;
        }
        int startBlk = cur;
        for (int i = 0; i < this.baseBufferCount; ++i) {
            this.samplesArr[cur] = this.combinedBuffer[i];
            this.weightsArr[cur] = 1L;
            ++cur;
        }
        this.weightsArr[cur] = 0L;
        if (cur != numSamples) {
            throw new QuantileSketchException("Missing items when copying buffer to array");
        }
        Arrays.sort(this.samplesArr, startBlk, cur);
    }

    public void merge(HeapQuantileSketch other) {
        if (other == null || other.isEmpty()) {
            return;
        }
        if (other.k != this.k) {
            throw new QuantileSketchException("Merge sketches with different k");
        }
        SketchUtils.checkBitPattern(other.bitPattern, other.n, other.k);
        if (this.isEmpty()) {
            this.copy(other);
            return;
        }
        long totalN = this.n + other.n;
        for (int i = 0; i < other.baseBufferCount; ++i) {
            this.update(other.combinedBuffer[i]);
        }
        this.ensureLevels(totalN);
        float[] auxBuf = new float[this.k * 2];
        int level = 0;
        for (long bp = other.bitPattern; bp != 0L; bp >>>= 1) {
            if ((bp & 1L) != 0L) {
                this.inPlacePropagationMerge(level, other.combinedBuffer, this.k * (level + 2), auxBuf, 0);
            }
            ++level;
        }
        this.n = totalN;
        this.maxValue = Math.max(this.maxValue, other.maxValue);
        this.minValue = Math.min(this.minValue, other.minValue);
        this.samplesArr = null;
        this.weightsArr = null;
    }

    private void inPlacePropagationMerge(int beginLevel, float[] buf, int bufStart, float[] auxBuf, int auxBufStart) {
        float[] levelsArr = this.combinedBuffer;
        int endLevel = beginLevel;
        long tmp = this.bitPattern >>> beginLevel;
        while ((tmp & 1L) != 0L) {
            tmp >>>= 1;
            ++endLevel;
        }
        System.arraycopy(buf, bufStart, levelsArr, this.k * (endLevel + 2), this.k);
        SketchUtils.levelwisePropagation(this.bitPattern, this.k, beginLevel, endLevel, auxBuf, auxBufStart, levelsArr);
        this.bitPattern += 1L << beginLevel;
    }

    public void copy(HeapQuantileSketch other) {
        this.n = other.n;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        if (this.estimateN == -1L) {
            this.combinedBufferCapacity = other.combinedBufferCapacity;
            this.combinedBuffer = (float[])other.combinedBuffer.clone();
        } else if (other.combinedBufferCapacity > this.combinedBufferCapacity) {
            this.combinedBufferCapacity = other.combinedBufferCapacity;
            this.combinedBuffer = (float[])other.combinedBuffer.clone();
        } else {
            System.arraycopy(other.combinedBuffer, 0, this.combinedBuffer, 0, other.combinedBufferCapacity);
        }
        this.baseBufferCount = other.baseBufferCount;
        this.bitPattern = other.bitPattern;
        if (other.samplesArr != null && other.weightsArr != null) {
            this.samplesArr = (float[])other.samplesArr.clone();
            this.weightsArr = (long[])other.weightsArr.clone();
        }
    }

    public void serialize(ByteBuf buf) {
        buf.writeInt(this.k);
        buf.writeLong(this.n);
        buf.writeLong(this.estimateN);
        buf.writeFloat(this.minValue);
        buf.writeFloat(this.maxValue);
        buf.writeInt(this.combinedBufferCapacity);
        buf.writeInt(this.baseBufferCount);
        buf.writeLong(this.bitPattern);
        for (int i = 0; i < this.combinedBufferCapacity; ++i) {
            buf.writeFloat(this.combinedBuffer[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        this.k = buf.readInt();
        this.n = buf.readLong();
        this.estimateN = buf.readLong();
        this.minValue = buf.readFloat();
        this.maxValue = buf.readFloat();
        this.combinedBufferCapacity = buf.readInt();
        this.baseBufferCount = buf.readInt();
        this.bitPattern = buf.readLong();
        SketchUtils.checkBitPattern(this.bitPattern, this.n, this.k);
        this.combinedBuffer = new float[this.combinedBufferCapacity];
        for (int i = 0; i < this.combinedBufferCapacity; ++i) {
            this.combinedBuffer[i] = buf.readFloat();
        }
        this.samplesArr = null;
        this.weightsArr = null;
    }

    public int bufferLen() {
        return 44 + this.combinedBufferCapacity * 4;
    }

    public void serialize(ByteBuffer buf) {
        buf.putInt(this.k);
        buf.putLong(this.n);
        buf.putLong(this.estimateN);
        buf.putFloat(this.minValue);
        buf.putFloat(this.maxValue);
        buf.putInt(this.combinedBufferCapacity);
        buf.putInt(this.baseBufferCount);
        buf.putLong(this.bitPattern);
        for (int i = 0; i < this.combinedBufferCapacity; ++i) {
            buf.putFloat(this.combinedBuffer[i]);
        }
    }

    public void deserialize(ByteBuffer buf) {
        this.k = buf.getInt();
        this.n = buf.getLong();
        this.estimateN = buf.getLong();
        this.minValue = buf.getFloat();
        this.maxValue = buf.getFloat();
        this.combinedBufferCapacity = buf.getInt();
        this.baseBufferCount = buf.getInt();
        this.bitPattern = buf.getLong();
        SketchUtils.checkBitPattern(this.bitPattern, this.n, this.k);
        this.combinedBuffer = new float[this.combinedBufferCapacity];
        for (int i = 0; i < this.combinedBufferCapacity; ++i) {
            this.combinedBuffer[i] = buf.getFloat();
        }
        this.samplesArr = null;
        this.weightsArr = null;
    }

    public float getQuantile(float fraction) {
        SketchUtils.checkFraction(fraction);
        if (this.samplesArr == null || this.weightsArr == null) {
            this.makeSummary();
        }
        if (this.samplesArr.length == 0) {
            return Float.NaN;
        }
        if (fraction == 0.0f) {
            return this.minValue;
        }
        if (fraction == 1.0f) {
            return this.maxValue;
        }
        return this.getQuantileFromArr(fraction);
    }

    public float[] getQuantiles(float[] fractions) {
        SketchUtils.checkFractions(fractions);
        if (this.samplesArr == null || this.weightsArr == null) {
            this.makeSummary();
        }
        float[] res = new float[fractions.length];
        if (this.samplesArr.length == 0) {
            Arrays.fill(res, Float.NaN);
            return res;
        }
        for (int i = 0; i < fractions.length; ++i) {
            res[i] = fractions[i] == 0.0f ? this.minValue : (fractions[i] == 1.0f ? this.maxValue : this.getQuantileFromArr(fractions[i]));
        }
        return res;
    }

    public float[] getQuantiles(int evenPartition) {
        SketchUtils.checkEvenPartiotion(evenPartition);
        if (this.samplesArr == null || this.weightsArr == null) {
            this.makeSummary();
        }
        float[] res = new float[evenPartition];
        if (this.samplesArr.length == 0) {
            Arrays.fill(res, Float.NaN);
            return res;
        }
        res[0] = this.minValue;
        int index = 0;
        float curFrac = 0.0f;
        float step = 1.0f / (float)evenPartition;
        for (int i = 1; i < evenPartition; ++i) {
            long rank = (long)((float)this.n * (curFrac += step));
            rank = Math.min(rank, this.n - 1L);
            int left = index;
            int right = this.weightsArr.length - 1;
            while (left + 1 < right) {
                int mid = left + (right - left >> 1);
                if (this.weightsArr[mid] <= rank) {
                    left = mid;
                    continue;
                }
                right = mid;
            }
            res[i] = this.samplesArr[left];
            index = left;
        }
        return res;
    }

    private float getQuantileFromArr(float fraction) {
        long rank = (long)((float)this.n * fraction);
        if (rank == this.n) {
            --this.n;
        }
        int left = 0;
        int right = this.weightsArr.length - 1;
        while (left + 1 < right) {
            int mid = left + (right - left >> 1);
            if (this.weightsArr[mid] <= rank) {
                left = mid;
                continue;
            }
            right = mid;
        }
        return this.samplesArr[left];
    }

    public boolean isEmpty() {
        return this.n == 0L;
    }

    public int getK() {
        return this.k;
    }

    public long getEstimateN() {
        return this.estimateN;
    }

    public long getN() {
        return this.n;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }
}

