/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo.tree;

import com.tencent.angel.ml.GBDT.algo.RegTree.GradStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SplitEntry {
    private static final Log LOG = LogFactory.getLog(SplitEntry.class);
    public int fid;
    public float fvalue;
    public float lossChg;
    public GradStats leftGradStat;
    public GradStats rightGradStat;

    public SplitEntry(int fid, float fvalue, float lossChg) {
        this.fid = fid;
        this.fvalue = fvalue;
        this.lossChg = lossChg;
        this.leftGradStat = new GradStats();
        this.rightGradStat = new GradStats();
    }

    public SplitEntry() {
        this(-1, 0.0f, 0.0f);
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public void setFvalue(float fvalue) {
        this.fvalue = fvalue;
    }

    public void setLossChg(float lossChg) {
        this.lossChg = lossChg;
    }

    public int getFid() {
        return this.fid;
    }

    public float getFvalue() {
        return this.fvalue;
    }

    public float getLossChg() {
        return this.lossChg;
    }

    public boolean NeedReplace(float newLossChg, int splitFeature) {
        if (this.fid <= splitFeature) {
            return newLossChg > this.lossChg;
        }
        return !(this.lossChg > newLossChg);
    }

    public boolean update(SplitEntry e) {
        if (this.NeedReplace(e.lossChg, e.getFid())) {
            this.lossChg = e.lossChg;
            this.fid = e.fid;
            this.fvalue = e.fvalue;
            this.leftGradStat = e.leftGradStat;
            this.rightGradStat = e.rightGradStat;
            return true;
        }
        return false;
    }

    public boolean update(float newLossChg, int splitIdx, float newSplitValue, boolean defaultLeft) {
        if (this.NeedReplace(newLossChg, splitIdx)) {
            this.lossChg = newLossChg;
            if (defaultLeft) {
                splitIdx |= Integer.MIN_VALUE;
            }
            this.fid = splitIdx;
            this.fvalue = newSplitValue;
            return true;
        }
        return false;
    }

    public boolean update(float newLossChg, int splitFeature, float newSplitValue) {
        if (this.NeedReplace(newLossChg, splitFeature)) {
            this.lossChg = newLossChg;
            this.fid = splitFeature;
            this.fvalue = newSplitValue;
            return true;
        }
        return false;
    }

    public boolean defaultLeft() {
        return this.fid >> 31 != 0;
    }
}

