/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.algo.tree;

import com.tencent.angel.ml.GBDT.algo.RegTree.RegTDataStore;
import com.yahoo.sketches.quantiles.DoublesSketch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TYahooSketchSplit {
    public static float[][] getSplitValue(RegTDataStore dataStore, int splitNum) {
        int i;
        int numFeature = dataStore.featureMeta.numFeature;
        DoublesSketch[] sketches = new DoublesSketch[numFeature];
        for (int i2 = 0; i2 < sketches.length; ++i2) {
            sketches[i2] = DoublesSketch.builder().build();
        }
        for (int nid = 0; nid < dataStore.numRow; ++nid) {
            int[] indice = dataStore.instances[nid].getStorage().getIndices();
            for (i = 0; i < indice.length; ++i) {
                int fid = indice[i];
                sketches[fid].update((double)dataStore.instances[nid].get(fid));
            }
        }
        float[][] splitSet = new float[numFeature][splitNum];
        for (int fid = 0; fid < numFeature; ++fid) {
            if (sketches[fid].getQuantile(0.0) > 0.0) {
                splitSet[fid][0] = 0.0f;
                for (i = 1; i < splitNum; ++i) {
                    splitSet[fid][i] = (float)sketches[fid].getQuantile((double)((i - 1) / (splitNum - 2)));
                }
                continue;
            }
            if (sketches[fid].getQuantile(1.0) < 0.0) {
                splitSet[fid][splitNum - 1] = 0.0f;
                for (i = 0; i < splitNum - 1; ++i) {
                    splitSet[fid][i] = (float)sketches[fid].getQuantile((double)(i / (splitNum - 2)));
                }
                continue;
            }
            for (i = 0; i < splitNum; ++i) {
                splitSet[fid][i] = (float)sketches[fid].getQuantile((double)(i / (splitNum - 1)));
            }
        }
        return splitSet;
    }

    public static float[][] getSplitValue(RegTDataStore dataStore, int splitNum, List<Integer> cateFeat) {
        Object fid;
        Object indice;
        int numFeature = dataStore.featureMeta.numFeature;
        DoublesSketch[] sketches = new DoublesSketch[numFeature];
        HashMap cateFeatTable = new HashMap();
        for (Integer feat : cateFeat) {
            cateFeatTable.put(feat, new HashSet());
        }
        for (int i = 0; i < sketches.length; ++i) {
            sketches[i] = DoublesSketch.builder().build();
        }
        for (int nid = 0; nid < dataStore.numRow; ++nid) {
            indice = dataStore.instances[nid].getStorage().getIndices();
            for (int i = 0; i < ((Object)indice).length; ++i) {
                fid = indice[i];
                double fvalue = dataStore.instances[nid].get((int)fid);
                if (cateFeat.contains((int)fid)) {
                    ((Set)cateFeatTable.get((int)fid)).add(Float.valueOf((float)fvalue));
                    continue;
                }
                sketches[fid].update(fvalue);
            }
        }
        float[][] splitSet = new float[numFeature][splitNum];
        indice = cateFeatTable.entrySet().iterator();
        while (indice.hasNext()) {
            Map.Entry ent = (Map.Entry)indice.next();
            fid = (Integer)ent.getKey();
            int i = 1;
            Iterator iterator = ((Set)ent.getValue()).iterator();
            while (iterator.hasNext()) {
                float fvalue = ((Float)iterator.next()).floatValue();
                splitSet[fid][i++] = fvalue;
            }
        }
        for (int fid2 = 0; fid2 < numFeature; ++fid2) {
            int i;
            if (cateFeat.contains(fid2)) continue;
            if (sketches[fid2].getQuantile(0.0) > 0.0) {
                splitSet[fid2][0] = 0.0f;
                for (i = 1; i < splitNum; ++i) {
                    splitSet[fid2][i] = (float)sketches[fid2].getQuantile((double)((float)(i - 1) / (float)(splitNum - 2)));
                }
                continue;
            }
            if (sketches[fid2].getQuantile(1.0) < 0.0) {
                splitSet[fid2][splitNum - 1] = 0.0f;
                for (i = 0; i < splitNum - 1; ++i) {
                    splitSet[fid2][i] = (float)sketches[fid2].getQuantile((double)((float)i / (float)(splitNum - 2)));
                }
                continue;
            }
            for (i = 0; i < splitNum; ++i) {
                splitSet[fid2][i] = (float)sketches[fid2].getQuantile((double)((float)i / (float)(splitNum - 1)));
            }
        }
        return splitSet;
    }
}

