/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.metric;

import com.tencent.angel.ml.GBDT.metric.EvalMetric;

public class LogLossMetric
implements EvalMetric {
    @Override
    public String getName() {
        return "logloss";
    }

    @Override
    public float eval(float[] predProbs, float[] labels) {
        float errSum = 0.0f;
        for (int i = 0; i < predProbs.length; ++i) {
            errSum += this.evalOne(predProbs[i], labels[i]);
        }
        return errSum / (float)predProbs.length;
    }

    @Override
    public float evalOne(float predProb, float label) {
        float eps = 1.0E-16f;
        float pneg = 1.0f - predProb;
        if (predProb < eps) {
            return -label * (float)Math.log(eps) - (1.0f - label) * (float)Math.log(1.0f - eps);
        }
        if (pneg < eps) {
            return -label * (float)Math.log(1.0f - eps) - (1.0f - label) * (float)Math.log(eps);
        }
        return -label * (float)Math.log(predProb) - (1.0f - label) * (float)Math.log(pneg);
    }
}

