/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.objective;

import com.tencent.angel.ml.GBDT.objective.LossHelper;
import com.tencent.angel.ml.core.utils.Maths;

public class Loss {

    public static class DirectLogisticLoss
    extends LogisticLoss {
        @Override
        public float transPred(float x) {
            return x;
        }

        @Override
        public float firOrderGrad(float pred, float label) {
            pred = Maths.sigmoid(pred);
            return pred - label;
        }

        @Override
        public float secOrderGrad(float pred, float label) {
            float eps = 1.0E-16f;
            pred = Maths.sigmoid(pred);
            return Math.max(pred * (1.0f - pred), eps);
        }

        @Override
        public String defaultEvalMetric() {
            return "auc";
        }
    }

    public static class BinaryLogisticLoss
    extends LogisticLoss {
        @Override
        public String defaultEvalMetric() {
            return "error";
        }
    }

    public static class LogisticLoss
    implements LossHelper {
        @Override
        public float transPred(float x) {
            return Maths.sigmoid(x);
        }

        @Override
        public boolean checkLabel(float x) {
            return x >= 0.0f && x <= 1.0f;
        }

        @Override
        public float firOrderGrad(float pred, float label) {
            return pred - label;
        }

        @Override
        public float secOrderGrad(float pred, float label) {
            float eps = 1.0E-16f;
            return Math.max(pred * (1.0f - pred), eps);
        }

        @Override
        public float prob2Margin(float baseScore) {
            assert (baseScore > 0.0f && baseScore < 1.0f);
            return (float)Math.log(1.0 / (double)baseScore - 1.0);
        }

        @Override
        public String labelErrorMsg() {
            return "label must be in [0,1] for logistic regression";
        }

        @Override
        public String defaultEvalMetric() {
            return "rmse";
        }
    }

    public static class LinearSquareLoss
    implements LossHelper {
        @Override
        public float transPred(float x) {
            return x;
        }

        @Override
        public boolean checkLabel(float x) {
            return true;
        }

        @Override
        public float firOrderGrad(float pred, float label) {
            return pred - label;
        }

        @Override
        public float secOrderGrad(float pred, float label) {
            return 1.0f;
        }

        @Override
        public float prob2Margin(float baseScore) {
            return baseScore;
        }

        @Override
        public String labelErrorMsg() {
            return "";
        }

        @Override
        public String defaultEvalMetric() {
            return "rmse";
        }
    }
}

