/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.GBDT.psf;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.psagent.PSAgentContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class HistAggrParam
extends GetParam {
    private final int rowId;
    private final int splitNum;
    private float minChildWeight;
    private float regAlpha;
    private float regLambda;

    public HistAggrParam(int matrixId, int rowId, int splitNum, float minChildWeight, float regAlpha, float regLambda) {
        super(matrixId);
        this.rowId = rowId;
        this.splitNum = splitNum;
        this.minChildWeight = minChildWeight;
        this.regAlpha = regAlpha;
        this.regLambda = regLambda;
    }

    public List<PartitionGetParam> split() {
        List parts = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        int size = parts.size();
        ArrayList<PartitionGetParam> partParams = new ArrayList<PartitionGetParam>(size);
        for (PartitionKey part : parts) {
            partParams.add(new HistPartitionAggrParam(this.matrixId, part, this.rowId, this.splitNum, this.minChildWeight, this.regAlpha, this.regLambda));
        }
        return partParams;
    }

    public static class HistPartitionAggrParam
    extends PartitionGetParam {
        private int rowId;
        private int splitNum;
        private float minChildWeight;
        private float regAlpha;
        private float regLambda;

        public HistPartitionAggrParam(int matrixId, PartitionKey partKey, int rowId, int splitNum, float minChildWeight, float regAlpha, float regLambda) {
            super(matrixId, partKey);
            this.rowId = rowId;
            this.splitNum = splitNum;
            this.minChildWeight = minChildWeight;
            this.regAlpha = regAlpha;
            this.regLambda = regLambda;
        }

        public HistPartitionAggrParam() {
            this(0, null, 0, 0, 0.0f, 0.0f, 0.0f);
        }

        public void serialize(ByteBuf buf) {
            super.serialize(buf);
            buf.writeInt(this.rowId);
            buf.writeInt(this.splitNum);
            buf.writeFloat(this.minChildWeight);
            buf.writeFloat(this.regAlpha);
            buf.writeFloat(this.regLambda);
        }

        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.rowId = buf.readInt();
            this.splitNum = buf.readInt();
            this.minChildWeight = buf.readFloat();
            this.regAlpha = buf.readFloat();
            this.regLambda = buf.readFloat();
        }

        public int bufferLen() {
            return super.bufferLen() + 8 + 12;
        }

        public int getRowId() {
            return this.rowId;
        }

        public int getSplitNum() {
            return this.splitNum;
        }

        public float getMinChildWeight() {
            return this.minChildWeight;
        }

        public float getRegAlpha() {
            return this.regAlpha;
        }

        public float getRegLambda() {
            return this.regLambda;
        }
    }
}

