/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.clustering.kmeans;

import com.tencent.angel.ml.clustering.kmeans.KMeansLearner$;
import com.tencent.angel.ml.clustering.kmeans.KMeansModel;
import com.tencent.angel.ml.core.MLLearner;
import com.tencent.angel.ml.core.conf.MLConf$;
import com.tencent.angel.ml.core.conf.SharedConf$;
import com.tencent.angel.ml.feature.LabeledData;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.update.base.VoidResult;
import com.tencent.angel.ml.metric.LossMetric$;
import com.tencent.angel.ml.model.MLModel;
import com.tencent.angel.worker.storage.DataBlock;
import com.tencent.angel.worker.task.TaskContext;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001=\u0011QbS'fC:\u001cH*Z1s]\u0016\u0014(BA\u0002\u0005\u0003\u0019YW.Z1og*\u0011QAB\u0001\u000bG2,8\u000f^3sS:<'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)\u0011M\\4fY*\u00111\u0002D\u0001\bi\u0016t7-\u001a8u\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\t\u0019b!\u0001\u0003d_J,\u0017BA\u000b\u0013\u0005%iE\nT3be:,'\u000fC\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019A\u0005\u00191\r\u001e=\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u0002;bg.T!!\b\u0005\u0002\r]|'o[3s\u0013\ty\"DA\u0006UCN\\7i\u001c8uKb$\u0018BA\f\u0015\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006/\u0005\u0002\r\u0001\u0007\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u0003\raujR\u000b\u0002UA\u00111\u0006N\u0007\u0002Y)\u0011QFL\u0001\bY><w-\u001b8h\u0015\ty\u0003'A\u0004d_6lwN\\:\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0005\u0003k1\u00121\u0001T8h\u0011\u00199\u0004\u0001)A\u0005U\u0005!AjT$!\u0011\u001dI\u0004A1A\u0005\u0002i\n!\"\u001b8eKb\u0014\u0016M\\4f+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001\u0002'p]\u001eDaA\u0011\u0001!\u0002\u0013Y\u0014aC5oI\u0016D(+\u00198hK\u0002Bq\u0001\u0012\u0001C\u0002\u0013\u0005Q)\u0001\u0005fa>\u001c\u0007NT;n+\u00051\u0005C\u0001\u001fH\u0013\tAUHA\u0002J]RDaA\u0013\u0001!\u0002\u00131\u0015!C3q_\u000eDg*^7!\u0011\u001da\u0005A1A\u0005\u0002\u0015\u000b\u0011a\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002$\u0002\u0005-\u0003\u0003b\u0002)\u0001\u0005\u0004%\t!U\u0001\u0002\u0007V\t!\u000b\u0005\u0002='&\u0011A+\u0010\u0002\u0007\t>,(\r\\3\t\rY\u0003\u0001\u0015!\u0003S\u0003\t\u0019\u0005\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u0017-lW-\u00198t\u001b>$W\r\\\u000b\u00025B\u0011QeW\u0005\u00039\n\u00111bS'fC:\u001cXj\u001c3fY\"1a\f\u0001Q\u0001\ni\u000bAb[7fC:\u001cXj\u001c3fY\u0002BQ\u0001\u0019\u0001\u0005B\u0005\fQ\u0001\u001e:bS:$2A\u00195w!\t\u0019g-D\u0001e\u0015\t)g!A\u0003n_\u0012,G.\u0003\u0002hI\n9Q\nT'pI\u0016d\u0007\"B5`\u0001\u0004Q\u0017!\u0003;sC&tG)\u0019;b!\rYg\u000e]\u0007\u0002Y*\u0011Q\u000eH\u0001\bgR|'/Y4f\u0013\tyGNA\u0005ECR\f'\t\\8dWB\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\bM\u0016\fG/\u001e:f\u0013\t)(OA\u0006MC\n,G.\u001a3ECR\f\u0007\"B<`\u0001\u0004Q\u0017\u0001\u0003<bY&$\u0015\r^1\t\u000be\u0004A\u0011\u0001>\u0002)%t\u0017\u000e^&DK:$XM]:SC:$w.\u001c7z)\tYh\u0010\u0005\u0002=y&\u0011Q0\u0010\u0002\u0005+:LG\u000fC\u0003\u0000q\u0002\u0007!.A\u0006eCR\f7\u000b^8sC\u001e,\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000eiJ\f\u0017N\\(oK\u0016\u0003xn\u00195\u0015\u000fm\f9!a\u0003\u0002\u000e!9\u0011\u0011BA\u0001\u0001\u00041\u0015!B3q_\u000eD\u0007BB5\u0002\u0002\u0001\u0007!\u000e\u0003\u0005\u0002\u0010\u0005\u0005\u0001\u0019AA\t\u0003Y\u0001XM]0dK:$XM]0ti\u0016\u0004xlY8v]R\u001c\b\u0003\u0002\u001f\u0002\u0014\u0019K1!!\u0006>\u0005\u0015\t%O]1z\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tQ\"\u001e9eCR,7)\u001a8uKJ\u001cH#B>\u0002\u001e\u0005\u0005\u0003\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\u0015=dGmQ3oi\u0016\u00148\u000f\u0005\u0004\u0002$\u00055\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005!Q\u000f^5m\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u00051a/Z2u_JT1!a\u000f\u0007\u0003\u0015i\u0017\r\u001e53\u0013\u0011\ty$!\u000e\u0003\rY+7\r^8s\u0011!\t\u0019%a\u0006A\u0002\u0005E\u0012!B8mIZ\u001b\bbBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u000fE\u0006$8\r[$f]\u0016\u0014\u0018\r^8s)!\tY%a\u0019\u0002f\u0005-\u0004#BA'\u0003;Zh\u0002BA(\u00033rA!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+r\u0011A\u0002\u001fs_>$h(C\u0001?\u0013\r\tY&P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0011%#XM]1u_JT1!a\u0017>\u0011\u0019I\u0017Q\ta\u0001U\"A\u0011qMA#\u0001\u0004\tI'A\u0005cCR\u001c\u0007\u000eR1uCB!A(a\u0005q\u0011\u001d\ti'!\u0012A\u0002\u0019\u000b\u0001BY1uG\"tU/\u001c\u0005\b\u0003c\u0002A\u0011AA:\u0003=\u0019w.\u001c9vi\u0016|%M\u001b,bYV,G#\u0002*\u0002v\u0005]\u0004BB@\u0002p\u0001\u0007!\u000eC\u0004\u0002\n\u0005=\u0004\u0019\u0001$\t\u001b\u0005m\u0004\u0001%A\u0002\u0002\u0003%I!! !\u0003%\u0019X\u000f]3sI\r$\b0F\u0001\u0019\u0001")
public class KMeansLearner
extends MLLearner {
    private final Log LOG = LogFactory.getLog(KMeansLearner.class);
    private final long indexRange = SharedConf$.MODULE$.indexRange();
    private final int epochNum = SharedConf$.MODULE$.epochNum();
    private final int K = this.conf().getInt(MLConf$.MODULE$.KMEANS_CENTER_NUM(), MLConf$.MODULE$.DEFAULT_KMEANS_CENTER_NUM());
    private final double C = this.conf().getDouble(MLConf$.MODULE$.KMEANS_C(), MLConf$.MODULE$.DEFAULT_KMEANS_C());
    private final KMeansModel kmeansModel;

    public /* synthetic */ TaskContext com$tencent$angel$ml$clustering$kmeans$KMeansLearner$$super$ctx() {
        return super.ctx();
    }

    public Log LOG() {
        return this.LOG;
    }

    public long indexRange() {
        return this.indexRange;
    }

    public int epochNum() {
        return this.epochNum;
    }

    public int K() {
        return this.K;
    }

    public double C() {
        return this.C;
    }

    public KMeansModel kmeansModel() {
        return this.kmeansModel;
    }

    @Override
    public MLModel train(DataBlock<LabeledData> trainData, DataBlock<LabeledData> valiData) {
        VoidResult voidResult;
        int[] spCountPerCenter = new int[this.K()];
        if (SharedConf$.MODULE$.useShuffle()) {
            trainData.shuffle();
        }
        if (super.ctx().getTaskId().getIndex() == 0 && this.conf().get("angel.load.model.path", "").isEmpty()) {
            this.initKCentersRandomly(trainData);
            voidResult = BoxedUnit.UNIT;
        } else {
            voidResult = this.kmeansModel().centers().syncClock(this.kmeansModel().centers().syncClock$default$1());
        }
        this.globalMetrics().addMetric(MLConf$.MODULE$.TRAIN_LOSS(), LossMetric$.MODULE$.apply(trainData.size()));
        this.globalMetrics().addMetric(MLConf$.MODULE$.VALID_LOSS(), LossMetric$.MODULE$.apply(valiData.size()));
        while (super.ctx().getEpoch() < this.epochNum()) {
            long startEpoch = System.currentTimeMillis();
            this.trainOneEpoch(super.ctx().getEpoch(), trainData, spCountPerCenter);
            long epochTime = System.currentTimeMillis() - startEpoch;
            long startObj = System.currentTimeMillis();
            double localObj = this.computeObjValue(trainData, super.ctx().getEpoch());
            long objTime = System.currentTimeMillis() - startObj;
            double valiObj = this.computeObjValue(valiData, super.ctx().getEpoch());
            this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] Iter=", " success. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.ctx().getContext().getIndex()), BoxesRunTime.boxToInteger((int)super.ctx().getEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"totalloss=", ". mini-batch cost ", " ms, compute "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)localObj), BoxesRunTime.boxToLong((long)epochTime)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"obj cost ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)objTime)}))).toString());
            this.globalMetrics().metric(MLConf$.MODULE$.TRAIN_LOSS(), localObj);
            this.globalMetrics().metric(MLConf$.MODULE$.VALID_LOSS(), valiObj);
            super.ctx().incEpoch();
        }
        return this.kmeansModel();
    }

    public void initKCentersRandomly(DataBlock<LabeledData> dataStorage) {
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] Initialize cluster centers with randomly choosen "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.ctx().getContext().getIndex())}))).append((Object)"samples.").toString());
        long start = System.currentTimeMillis();
        Random rand = new Random(System.currentTimeMillis());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.K()).foreach$mVc$sp((Function1)new Serializable(this, dataStorage, rand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansLearner $outer;
            private final DataBlock dataStorage$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (i % this.$outer.com$tencent$angel$ml$clustering$kmeans$KMeansLearner$$super$ctx().getTotalTaskNum() == this.$outer.com$tencent$angel$ml$clustering$kmeans$KMeansLearner$$super$ctx().getTaskId().getIndex()) {
                    com.tencent.angel.ml.math2.vector.Vector newCent = ((LabeledData)this.dataStorage$1.get(this.rand$1.nextInt(this.dataStorage$1.size()))).getX();
                    newCent.setRowId(i);
                    this.$outer.kmeansModel().centers().increment(newCent);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataStorage$1 = dataStorage$1;
                this.rand$1 = rand$1;
            }
        });
        this.kmeansModel().centers().syncClock(this.kmeansModel().centers().syncClock$default$1());
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All tasks Init cluster centers success, cost ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ms"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public void trainOneEpoch(int epoch, DataBlock<LabeledData> trainData, int[] per_center_step_counts) {
        long startEpoch = System.currentTimeMillis();
        this.kmeansModel().pullCentersFromPS();
        this.kmeansModel().pullVFromPS();
        long pullCost = System.currentTimeMillis() - startEpoch;
        ArrayList<com.tencent.angel.ml.math2.vector.Vector> oldCenters = new ArrayList<com.tencent.angel.ml.math2.vector.Vector>(this.K());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.K()).foreach((Function1)new Serializable(this, oldCenters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansLearner $outer;
            private final ArrayList oldCenters$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.oldCenters$1.add(this.$outer.kmeansModel().lcCenters().get(i).copy());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oldCenters$1 = oldCenters$1;
            }
        });
        IntFloatVector oldVs = this.kmeansModel().lcV().copy();
        int batchNum = SharedConf$.MODULE$.numUpdatePerEpoch();
        int batchSize = (trainData.size() + batchNum - 1) / batchNum;
        LabeledData[] batchData = new LabeledData[batchSize];
        Iterator<BoxedUnit> iter = this.batchGenerator(trainData, batchData, batchNum);
        long startMbatch = System.currentTimeMillis();
        while (iter.hasNext()) {
            iter.next();
            Predef$.MODULE$.refArrayOps((Object[])batchData).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeansLearner $outer;

                public final void apply(LabeledData ld) {
                    int cId = BoxesRunTime.unboxToInt((Object)this.$outer.kmeansModel().findClosestCenter(ld.getX())._1());
                    this.$outer.kmeansModel().lcV().set(cId, this.$outer.kmeansModel().lcV().get(cId) + 1.0f);
                    double eta = this.$outer.C() / ((double)this.$outer.kmeansModel().lcV().get(cId) + this.$outer.C());
                    this.$outer.kmeansModel().lcCenters().get(cId).imul(1.0 - eta).iaxpy(ld.getX(), eta);
                    this.$outer.kmeansModel().updateCenterDist(cId);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        long batchCost = System.currentTimeMillis() - startMbatch;
        long startUpdate = System.currentTimeMillis();
        this.updateCenters(oldCenters, (com.tencent.angel.ml.math2.vector.Vector)oldVs);
        long updateCost = System.currentTimeMillis() - startUpdate;
        long epochCost = System.currentTimeMillis() - startEpoch;
        this.LOG().debug((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] Iteration[", "] pull centers from PS cost "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.ctx().getContext().getIndex()), BoxesRunTime.boxToInteger((int)epoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms, push centers to PS cost ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)pullCost), BoxesRunTime.boxToLong((long)updateCost)}))).toString());
    }

    public void updateCenters(ArrayList<com.tencent.angel.ml.math2.vector.Vector> oldCenters, com.tencent.angel.ml.math2.vector.Vector oldVs) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.K()).foreach$mVc$sp((Function1)new Serializable(this, oldCenters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansLearner $outer;
            private final ArrayList oldCenters$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                com.tencent.angel.ml.math2.vector.Vector centerUpdate = this.$outer.kmeansModel().lcCenters().get(i).sub((com.tencent.angel.ml.math2.vector.Vector)this.oldCenters$2.get(i));
                this.$outer.kmeansModel().centers().increment(centerUpdate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oldCenters$2 = oldCenters$2;
            }
        });
        com.tencent.angel.ml.math2.vector.Vector counterUpdate = this.kmeansModel().lcV().sub(oldVs);
        this.kmeansModel().v().increment(counterUpdate);
        this.kmeansModel().centers().syncClock(this.kmeansModel().centers().syncClock$default$1());
        this.kmeansModel().v().syncClock(this.kmeansModel().v().syncClock$default$1());
    }

    public Iterator<BoxedUnit> batchGenerator(DataBlock<LabeledData> trainData, LabeledData[] batchData, int batchNum) {
        return new Iterator<BoxedUnit>(this, trainData, batchData, batchNum){
            private int count;
            public final DataBlock trainData$1;
            public final LabeledData[] batchData$1;
            private final int batchNum$1;

            public Iterator<BoxedUnit> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<BoxedUnit> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<BoxedUnit> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<BoxedUnit> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<BoxedUnit, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<BoxedUnit, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<BoxedUnit> filter(Function1<BoxedUnit, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<BoxedUnit, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<BoxedUnit> withFilter(Function1<BoxedUnit, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<BoxedUnit> filterNot(Function1<BoxedUnit, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<BoxedUnit, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, BoxedUnit, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<BoxedUnit, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<BoxedUnit> takeWhile(Function1<BoxedUnit, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<BoxedUnit>, Iterator<BoxedUnit>> partition(Function1<BoxedUnit, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<BoxedUnit>, Iterator<BoxedUnit>> span(Function1<BoxedUnit, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<BoxedUnit> dropWhile(Function1<BoxedUnit, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<BoxedUnit, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<BoxedUnit, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<BoxedUnit, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<BoxedUnit, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<BoxedUnit, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<BoxedUnit> find(Function1<BoxedUnit, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<BoxedUnit, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<BoxedUnit> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<BoxedUnit>, Iterator<BoxedUnit>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<BoxedUnit> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<BoxedUnit> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<BoxedUnit> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<BoxedUnit> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<BoxedUnit, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<BoxedUnit, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, BoxedUnit, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<BoxedUnit, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, BoxedUnit, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<BoxedUnit, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, BoxedUnit, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<BoxedUnit, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, BoxedUnit, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<BoxedUnit, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, BoxedUnit, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<BoxedUnit> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<BoxedUnit> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<BoxedUnit> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<BoxedUnit> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<BoxedUnit> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, BoxedUnit, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<BoxedUnit, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private int count() {
                return this.count;
            }

            private void count_$eq(int x$1) {
                this.count = x$1;
            }

            public boolean hasNext() {
                return this.count() < this.batchNum$1;
            }

            public void next() {
                double pivot = Math.random();
                Predef$.MODULE$.refArrayOps((Object[])this.batchData$1).indices().foreach$mVc$sp((Function1)new Serializable(this, pivot){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    private final double pivot$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        boolean flag = true;
                        while (flag) {
                            LabeledData tmpVector = (LabeledData)this.$outer.trainData$1.loopingRead();
                            if (!(Math.random() < this.pivot$1)) continue;
                            this.$outer.batchData$1[i] = tmpVector;
                            flag = false;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.pivot$1 = pivot$1;
                    }
                });
                this.count_$eq(this.count() + 1);
            }
            {
                this.trainData$1 = trainData$1;
                this.batchData$1 = batchData$1;
                this.batchNum$1 = batchNum$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.count = 0;
            }
        };
    }

    public double computeObjValue(DataBlock<LabeledData> dataStorage, int epoch) {
        DoubleRef obj = DoubleRef.create((double)0.0);
        dataStorage.resetReadIndex();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dataStorage.size()).foreach$mVc$sp((Function1)new Serializable(this, dataStorage, obj){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansLearner $outer;
            private final DataBlock dataStorage$2;
            private final DoubleRef obj$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                com.tencent.angel.ml.math2.vector.Vector vec = ((LabeledData)this.dataStorage$2.read()).getX();
                Tuple3<Object, Object, Object> cIdDist = this.$outer.kmeansModel().findClosestCenter(vec);
                this.obj$1.elem += BoxesRunTime.unboxToDouble((Object)cIdDist._2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataStorage$2 = dataStorage$2;
                this.obj$1 = obj$1;
            }
        });
        return obj.elem;
    }

    public KMeansLearner(TaskContext ctx) {
        super(ctx);
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] Start KMeans learner, K=", ", C=", ", #Feature=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.ctx().getTaskIndex()), BoxesRunTime.boxToInteger((int)this.K()), BoxesRunTime.boxToDouble((double)this.C()), BoxesRunTime.boxToLong((long)this.indexRange())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#Iteration=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.epochNum())}))).toString());
        this.kmeansModel = new KMeansModel(this.conf(), super.ctx());
    }
}

