/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.clustering.kmeans;

import com.tencent.angel.ml.clustering.kmeans.KMeansLearner;
import com.tencent.angel.ml.core.TrainTask;
import com.tencent.angel.ml.core.conf.SharedConf$;
import com.tencent.angel.ml.core.utils.DataParser;
import com.tencent.angel.ml.core.utils.DataParser$;
import com.tencent.angel.ml.feature.LabeledData;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.worker.storage.DataBlock;
import com.tencent.angel.worker.storage.DiskDataBlock;
import com.tencent.angel.worker.storage.MemoryAndDiskDataBlock;
import com.tencent.angel.worker.storage.MemoryDataBlock;
import com.tencent.angel.worker.storage.Reader;
import com.tencent.angel.worker.task.TaskContext;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001=\u0011qbS'fC:\u001cHK]1j]R\u000b7o\u001b\u0006\u0003\u0007\u0011\taa[7fC:\u001c(BA\u0003\u0007\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B1oO\u0016d'BA\u0006\r\u0003\u001d!XM\\2f]RT\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001B!\u0005\u000b\u0017E5\t!C\u0003\u0002\u0014\r\u0005!1m\u001c:f\u0013\t)\"CA\u0005Ue\u0006Lg\u000eV1tWB\u0011q\u0003I\u0007\u00021)\u0011\u0011DG\u0001\u0003S>T!a\u0007\u000f\u0002\r!\fGm\\8q\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005B\"\u0001\u0004'p]\u001e<&/\u001b;bE2,\u0007CA\f$\u0013\t!\u0003D\u0001\u0003UKb$\b\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\u0014\u0002\u0007\r$\b0F\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003uCN\\'BA\u0017\t\u0003\u00199xN]6fe&\u0011qF\u000b\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003)\u0003\u0011\u0019G\u000f\u001f\u0011\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\t)t\u0007\u0005\u00027\u00015\t!\u0001C\u0003'e\u0001\u0007\u0001\u0006C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\u0002\u00071{u)F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u0001c\u0012aB2p[6|gn]\u0005\u0003\u0005v\u00121\u0001T8h\u0011\u0019!\u0005\u0001)A\u0005w\u0005!AjT$!\u0011%1\u0005\u00011AA\u0002\u0013\u0005q)\u0001\u0006jIb\u001ch+Z2u_J,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000baA^3di>\u0014(BA'\u0007\u0003\u0015i\u0017\r\u001e53\u0013\ty%J\u0001\u0004WK\u000e$xN\u001d\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002I\u000ba\"\u001b3ygZ+7\r^8s?\u0012*\u0017\u000f\u0006\u0002T3B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n!QK\\5u\u0011\u001dQ\u0006+!AA\u0002!\u000b1\u0001\u001f\u00132\u0011\u0019a\u0006\u0001)Q\u0005\u0011\u0006Y\u0011\u000e\u001a=t-\u0016\u001cGo\u001c:!\u0011\u001dq\u0006A1A\u0005\u0002}\u000b!\"\u001b8eKb\u0014\u0016M\\4f+\u0005\u0001\u0007C\u0001+b\u0013\t\u0011WK\u0001\u0003M_:<\u0007B\u00023\u0001A\u0003%\u0001-A\u0006j]\u0012,\u0007PU1oO\u0016\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\bm\u0006d\u0017NU1u+\u0005A\u0007C\u0001+j\u0013\tQWK\u0001\u0004E_V\u0014G.\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002\u0011Y\fG.\u001b*bi\u0002BqA\u001c\u0001C\u0002\u0013\u0005s.\u0001\u0006eCR\f\u0007+\u0019:tKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gJ\tQ!\u001e;jYNL!!\u001e:\u0003\u0015\u0011\u000bG/\u0019)beN,'\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001]\u0001\fI\u0006$\u0018\rU1sg\u0016\u0014\b\u0005C\u0004z\u0001\t\u0007I\u0011\u0001>\u0002\u001dY\fG.\u001b3ECR\f'\t\\8dWV\t1\u0010\u0005\u0003}\u007f\u0006\rQ\"A?\u000b\u0005yd\u0013aB:u_J\fw-Z\u0005\u0004\u0003\u0003i(!\u0003#bi\u0006\u0014En\\2l!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00059a-Z1ukJ,\u0017\u0002BA\u0007\u0003\u000f\u00111\u0002T1cK2,G\rR1uC\"9\u0011\u0011\u0003\u0001!\u0002\u0013Y\u0018a\u0004<bY&$G)\u0019;b\u00052|7m\u001b\u0011\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u0005)AO]1j]R\u00191+!\u0007\t\r\u0019\n\u0019\u00021\u0001)\u0011\u001d\ti\u0002\u0001C!\u0003?\tQ\u0001]1sg\u0016$b!a\u0001\u0002\"\u0005\u0015\u0002bBA\u0012\u00037\u0001\rAF\u0001\u0004W\u0016L\bbBA\u0014\u00037\u0001\rAI\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003W\u0001A\u0011IA\u0017\u0003)\u0001(/\u001a)s_\u000e,7o\u001d\u000b\u0004'\u0006=\u0002bBA\u0019\u0003S\u0001\r\u0001K\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000fC\u0004\u00026\u0001!\t!a\u000e\u0002\u0019\u001d,G\u000fR1uC\ncwnY6\u0015\u0007m\fI\u0004\u0003\u0006\u0002<\u0005M\u0002\u0013!a\u0001\u0003{\tQ\u0001\\3wK2\u0004B!a\u0010\u0002F9\u0019A+!\u0011\n\u0007\u0005\rS+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\nIE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007*\u0006\"CA'\u0001E\u0005I\u0011AA(\u0003Y9W\r\u001e#bi\u0006\u0014En\\2lI\u0011,g-Y;mi\u0012\nTCAA)U\u0011\ti$a\u0015,\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0018V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\nIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class KMeansTrainTask
extends TrainTask<LongWritable, Text> {
    private final TaskContext ctx;
    private final Log LOG;
    private Vector idxsVector;
    private final long indexRange;
    private final double valiRat;
    private final DataParser dataParser;
    private final DataBlock<LabeledData> validDataBlock;

    public TaskContext ctx() {
        return this.ctx;
    }

    private Log LOG() {
        return this.LOG;
    }

    public Vector idxsVector() {
        return this.idxsVector;
    }

    public void idxsVector_$eq(Vector x$1) {
        this.idxsVector = x$1;
    }

    public long indexRange() {
        return this.indexRange;
    }

    private double valiRat() {
        return this.valiRat;
    }

    @Override
    public DataParser dataParser() {
        return this.dataParser;
    }

    public DataBlock<LabeledData> validDataBlock() {
        return this.validDataBlock;
    }

    @Override
    public void train(TaskContext ctx) {
        this.LOG().info((Object)new StringBuilder().append((Object)"#TrainSample=").append((Object)BoxesRunTime.boxToInteger((int)this.taskDataBlock.size())).toString());
        KMeansLearner learner = new KMeansLearner(ctx);
        learner.train((DataBlock<LabeledData>)this.taskDataBlock, this.validDataBlock());
    }

    public LabeledData parse(LongWritable key, Text value) {
        return this.dataParser().parse(value.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preProcess(TaskContext taskContext) {
        Vector vector;
        long start = System.currentTimeMillis();
        int count = 0;
        int vali = (int)Math.ceil(1.0 / this.valiRat());
        Reader reader = taskContext.getReader();
        if (this.needIndexs()) {
            Vector vector2;
            int expected = Math.max(256, (int)(SharedConf$.MODULE$.indexRange() / 10000L));
            String string = SharedConf$.MODULE$.keyType();
            if ("int".equals(string)) {
                IntOpenHashSet idxs = new IntOpenHashSet(expected);
                while (reader.nextKeyValue()) {
                    LabeledData out = this.parse((LongWritable)reader.getCurrentKey(), (Text)reader.getCurrentValue());
                    if (out == null) continue;
                    this.addIndexs(out.getX(), idxs);
                    if (count % vali == 0) {
                        this.validDataBlock().put((Object)out);
                    } else {
                        this.taskDataBlock.put((Object)out);
                    }
                    ++count;
                }
                vector2 = this.set2Vector(idxs);
            } else {
                if (!"long".equals(string)) throw new MatchError((Object)string);
                LongOpenHashSet idxs = new LongOpenHashSet(expected);
                while (reader.nextKeyValue()) {
                    LabeledData out = this.parse((LongWritable)reader.getCurrentKey(), (Text)reader.getCurrentValue());
                    if (out == null) continue;
                    this.addIndexs(out.getX(), idxs);
                    if (count % vali == 0) {
                        this.validDataBlock().put((Object)out);
                    } else {
                        this.taskDataBlock.put((Object)out);
                    }
                    ++count;
                }
                vector2 = this.set2Vector(idxs);
            }
            vector = vector2;
        } else {
            while (reader.nextKeyValue()) {
                LabeledData out = this.parse((LongWritable)reader.getCurrentKey(), (Text)reader.getCurrentValue());
                if (out == null) continue;
                if (count % vali == 0) {
                    this.validDataBlock().put((Object)out);
                } else {
                    this.taskDataBlock.put((Object)out);
                }
                ++count;
            }
            vector = null;
        }
        this.idxsVector_$eq(vector);
        this.taskDataBlock.flush();
        this.validDataBlock().flush();
        long cost = System.currentTimeMillis() - start;
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] preprocessed ", " samples, ", " for train, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ctx().getTaskIndex()), BoxesRunTime.boxToInteger((int)(this.taskDataBlock.size() + this.validDataBlock().size())), BoxesRunTime.boxToInteger((int)this.taskDataBlock.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for validation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.validDataBlock().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" processing time is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cost)}))).toString());
    }

    public DataBlock<LabeledData> getDataBlock(String level) {
        String storageLevel;
        String string = storageLevel = level != null && level.length() != 0 ? level : SharedConf$.MODULE$.storageLevel();
        return storageLevel.equalsIgnoreCase("memory") ? new MemoryDataBlock(-1) : (storageLevel.equalsIgnoreCase("memory_disk") ? new MemoryAndDiskDataBlock(this.ctx().getTaskId().getIndex()) : new DiskDataBlock(this.ctx().getTaskId().getIndex()));
    }

    public String getDataBlock$default$1() {
        return null;
    }

    public KMeansTrainTask(TaskContext ctx) {
        this.ctx = ctx;
        super(ctx);
        this.LOG = LogFactory.getLog(KMeansTrainTask.class);
        this.indexRange = SharedConf$.MODULE$.indexRange();
        this.valiRat = SharedConf$.MODULE$.validateRatio();
        this.dataParser = DataParser$.MODULE$.apply(SharedConf$.MODULE$.get(this.conf));
        this.validDataBlock = this.getDataBlock("memory");
    }
}

