/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.core.graphsubmit;

import com.tencent.angel.ml.core.TrainTask;
import com.tencent.angel.ml.core.conf.SharedConf$;
import com.tencent.angel.ml.core.graphsubmit.GraphLearner;
import com.tencent.angel.ml.core.utils.DataParser;
import com.tencent.angel.ml.core.utils.DataParser$;
import com.tencent.angel.ml.feature.LabeledData;
import com.tencent.angel.ml.matrix.RowType;
import com.tencent.angel.worker.storage.DataBlock;
import com.tencent.angel.worker.storage.DiskDataBlock;
import com.tencent.angel.worker.storage.MemoryAndDiskDataBlock;
import com.tencent.angel.worker.storage.MemoryDataBlock;
import com.tencent.angel.worker.storage.Reader;
import com.tencent.angel.worker.task.TaskContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001=\u0011ab\u0012:ba\"$&/Y5o)\u0006\u001c8N\u0003\u0002\u0004\t\u0005YqM]1qQN,(-\\5u\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)\u0011M\\4fY*\u00111\u0002D\u0001\bi\u0016t7-\u001a8u\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\u0011\t\"\u0003\u0006\u0011\u000e\u0003\u0011I!a\u0005\u0003\u0003\u0013Q\u0013\u0018-\u001b8UCN\\\u0007CA\u000b\u001f\u001b\u00051\"BA\f\u0019\u0003\tIwN\u0003\u0002\u001a5\u00051\u0001.\u00193p_BT!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO&\u0011qD\u0006\u0002\r\u0019>twm\u0016:ji\u0006\u0014G.\u001a\t\u0003+\u0005J!A\t\f\u0003\tQ+\u0007\u0010\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005\u00191\r\u001e=\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001\u0002;bg.T!A\u000b\u0005\u0002\r]|'o[3s\u0013\tasEA\u0006UCN\\7i\u001c8uKb$\b\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\b\u0006\u00021eA\u0011\u0011\u0007A\u0007\u0002\u0005!)A%\fa\u0001K!9A\u0007\u0001b\u0001\n\u0003)\u0014a\u0001'P\u000fV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u00059An\\4hS:<'BA\u001e\u001b\u0003\u001d\u0019w.\\7p]NL!!\u0010\u001d\u0003\u00071{w\r\u0003\u0004@\u0001\u0001\u0006IAN\u0001\u0005\u0019>;\u0005\u0005C\u0004B\u0001\t\u0007I\u0011\u0002\"\u0002\u000fY\fG.\u001b*biV\t1\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\"\u0002\u0011Y\fG.\u001b*bi\u0002Bq\u0001\u0014\u0001C\u0002\u0013%!)A\u0006q_NtWm\u001a*bi&|\u0007B\u0002(\u0001A\u0003%1)\u0001\u0007q_NtWm\u001a*bi&|\u0007\u0005C\u0004Q\u0001\t\u0007I\u0011A)\u0002\u001dY\fG.\u001b3ECR\f'\t\\8dWV\t!\u000bE\u0002T-bk\u0011\u0001\u0016\u0006\u0003+&\nqa\u001d;pe\u0006<W-\u0003\u0002X)\nIA)\u0019;b\u00052|7m\u001b\t\u00033rk\u0011A\u0017\u0006\u00037\u001a\tqAZ3biV\u0014X-\u0003\u0002^5\nYA*\u00192fY\u0016$G)\u0019;b\u0011\u0019y\u0006\u0001)A\u0005%\u0006ya/\u00197jI\u0012\u000bG/\u0019\"m_\u000e\\\u0007\u0005C\u0004b\u0001\t\u0007I\u0011A)\u0002\u0019A|7\u000fR1uC\ncwnY6\t\r\r\u0004\u0001\u0015!\u0003S\u00035\u0001xn\u001d#bi\u0006\u0014En\\2lA!9Q\r\u0001b\u0001\n\u0003\t\u0016\u0001\u00048fO\u0012\u000bG/\u0019\"m_\u000e\\\u0007BB4\u0001A\u0003%!+A\u0007oK\u001e$\u0015\r^1CY>\u001c7\u000e\t\u0005\bS\u0002\u0011\r\u0011\"\u0011k\u0003)!\u0017\r^1QCJ\u001cXM]\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011a\u000eB\u0001\u0006kRLGn]\u0005\u0003a6\u0014!\u0002R1uCB\u000b'o]3s\u0011\u0019\u0011\b\u0001)A\u0005W\u0006YA-\u0019;b!\u0006\u00148/\u001a:!\u0011\u001d!\bA1A\u0005\u0002U\f\u0011\"\\8eK2$\u0016\u0010]3\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0004\u0002\r5\fGO]5y\u0013\tY\bPA\u0004S_^$\u0016\u0010]3\t\ru\u0004\u0001\u0015!\u0003w\u0003)iw\u000eZ3m)f\u0004X\r\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002\u0005qQn\u001c3fY\u000ec\u0017m]:OC6,WCAA\u0002!\u0011\t)!a\u0003\u000f\u0007\u0011\u000b9!C\u0002\u0002\n\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005\u000b\"A\u00111\u0003\u0001!\u0002\u0013\t\u0019!A\bn_\u0012,Gn\u00117bgNt\u0015-\\3!\u0011\u001d\t9\u0002\u0001C!\u00033\tQ\u0001\u001e:bS:$B!a\u0007\u0002\"A\u0019A)!\b\n\u0007\u0005}QI\u0001\u0003V]&$\bB\u0002\u0013\u0002\u0016\u0001\u0007Q\u0005C\u0004\u0002&\u0001!\t%a\n\u0002\u000bA\f'o]3\u0015\u000ba\u000bI#!\f\t\u000f\u0005-\u00121\u0005a\u0001)\u0005\u00191.Z=\t\u000f\u0005=\u00121\u0005a\u0001A\u0005)a/\u00197vK\"9\u00111\u0007\u0001\u0005B\u0005U\u0012A\u00039sKB\u0013xnY3tgR!\u00111DA\u001c\u0011\u001d\tI$!\rA\u0002\u0015\n1\u0002^1tW\u000e{g\u000e^3yi\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001D4fi\u0012\u000bG/\u0019\"m_\u000e\\Gc\u0001*\u0002B!Q\u00111IA\u001e!\u0003\u0005\r!a\u0001\u0002\u000b1,g/\u001a7\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005%\u0013AF4fi\u0012\u000bG/\u0019\"m_\u000e\\G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-#\u0006BA\u0002\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033*\u0015AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class GraphTrainTask
extends TrainTask<LongWritable, Text> {
    private final TaskContext ctx;
    private final Log LOG;
    private final double valiRat;
    private final double posnegRatio;
    private final DataBlock<LabeledData> validDataBlock;
    private final DataBlock<LabeledData> posDataBlock;
    private final DataBlock<LabeledData> negDataBlock;
    private final DataParser dataParser;
    private final RowType modelType;
    private final String modelClassName;

    public Log LOG() {
        return this.LOG;
    }

    private double valiRat() {
        return this.valiRat;
    }

    private double posnegRatio() {
        return this.posnegRatio;
    }

    public DataBlock<LabeledData> validDataBlock() {
        return this.validDataBlock;
    }

    public DataBlock<LabeledData> posDataBlock() {
        return this.posDataBlock;
    }

    public DataBlock<LabeledData> negDataBlock() {
        return this.negDataBlock;
    }

    @Override
    public DataParser dataParser() {
        return this.dataParser;
    }

    public RowType modelType() {
        return this.modelType;
    }

    public String modelClassName() {
        return this.modelClassName;
    }

    @Override
    public void train(TaskContext ctx) {
        GraphLearner trainer = new GraphLearner(this.modelClassName(), ctx);
        if (this.posnegRatio() == (double)-1) {
            trainer.train((DataBlock<LabeledData>)this.taskDataBlock, this.validDataBlock());
        } else {
            trainer.train(this.posDataBlock(), this.negDataBlock(), this.validDataBlock());
        }
    }

    public LabeledData parse(LongWritable key, Text value) {
        return this.dataParser().parse(value.toString());
    }

    public void preProcess(TaskContext taskContext) {
        long start = System.currentTimeMillis();
        int count = 0;
        int vali = (int)Math.ceil(1.0 / this.valiRat());
        Reader reader = taskContext.getReader();
        while (reader.nextKeyValue()) {
            LabeledData out = this.parse((LongWritable)reader.getCurrentKey(), (Text)reader.getCurrentValue());
            if (out == null) continue;
            if (count % vali == 0) {
                this.validDataBlock().put((Object)out);
            } else if (this.posnegRatio() != (double)-1) {
                if (out.getY() > 0.0) {
                    this.posDataBlock().put((Object)out);
                } else {
                    this.negDataBlock().put((Object)out);
                }
            } else {
                this.taskDataBlock.put((Object)out);
            }
            ++count;
        }
        this.posDataBlock().flush();
        this.negDataBlock().flush();
        this.validDataBlock().flush();
        long cost = System.currentTimeMillis() - start;
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task[", "] preprocessed ", " samples, ", " for train, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ctx.getTaskIndex()), BoxesRunTime.boxToInteger((int)(this.taskDataBlock.size() + this.validDataBlock().size())), BoxesRunTime.boxToInteger((int)this.taskDataBlock.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for validation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.validDataBlock().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" processing time is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cost)}))).toString());
    }

    public DataBlock<LabeledData> getDataBlock(String level) {
        String storageLevel;
        String string = storageLevel = level != null && level.length() != 0 ? level : SharedConf$.MODULE$.storageLevel();
        return storageLevel.equalsIgnoreCase("memory") ? new MemoryDataBlock(-1) : (storageLevel.equalsIgnoreCase("memory_disk") ? new MemoryAndDiskDataBlock(this.ctx.getTaskId().getIndex()) : new DiskDataBlock(this.ctx.getTaskId().getIndex()));
    }

    public String getDataBlock$default$1() {
        return null;
    }

    public GraphTrainTask(TaskContext ctx) {
        this.ctx = ctx;
        super(ctx);
        this.LOG = LogFactory.getLog(GraphTrainTask.class);
        this.valiRat = SharedConf$.MODULE$.validateRatio();
        this.posnegRatio = SharedConf$.MODULE$.posnegRatio();
        this.validDataBlock = this.getDataBlock("memory");
        this.posDataBlock = this.taskDataBlock;
        this.negDataBlock = this.getDataBlock(this.getDataBlock$default$1());
        this.dataParser = DataParser$.MODULE$.apply(SharedConf$.MODULE$.get());
        this.modelType = SharedConf$.MODULE$.modelType();
        this.modelClassName = SharedConf$.MODULE$.modelClassName();
    }
}

